/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.sample.CustomService;
import io.javaoperatorsdk.operator.sample.ServiceSpec;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class CustomServiceReconciler
implements Reconciler<CustomService> {
    private static final Logger log = LoggerFactory.getLogger(CustomServiceReconciler.class);
    private final KubernetesClient kubernetesClient;

    public CustomServiceReconciler() {
        this((KubernetesClient)new DefaultKubernetesClient());
    }

    public CustomServiceReconciler(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public DeleteControl cleanup(CustomService resource, Context context) {
        log.info("Cleaning up for: {}", (Object)resource.getMetadata().getName());
        return super.cleanup((HasMetadata)resource, context);
    }

    public UpdateControl<CustomService> reconcile(CustomService resource, Context context) {
        log.info("Reconciling: {}", (Object)resource.getMetadata().getName());
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(8080));
        io.fabric8.kubernetes.api.model.ServiceSpec serviceSpec = new io.fabric8.kubernetes.api.model.ServiceSpec();
        serviceSpec.setPorts(Collections.singletonList(servicePort));
        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(resource.getMetadata().getNamespace())).createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(((ServiceSpec)resource.getSpec()).getName())).addToLabels("testLabel", ((ServiceSpec)resource.getSpec()).getLabel())).endMetadata()).withSpec(serviceSpec)).build()});
        return UpdateControl.updateResource((HasMetadata)resource);
    }
}

