/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.monitoring.micrometer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.GroupVersionKind;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEvent;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MicrometerMetrics
implements Metrics {
    private static final String PREFIX = "operator.sdk.";
    private static final String RECONCILIATIONS = "reconciliations.";
    private static final String RECONCILIATIONS_FAILED = "reconciliations.failed";
    private static final String RECONCILIATIONS_SUCCESS = "reconciliations.success";
    private static final String RECONCILIATIONS_RETRIES_LAST = "reconciliations.retries.last";
    private static final String RECONCILIATIONS_RETRIES_NUMBER = "reconciliations.retries.number";
    private static final String RECONCILIATIONS_STARTED = "reconciliations.started";
    private static final String RECONCILIATIONS_EXECUTIONS = "operator.sdk.reconciliations.executions.";
    private static final String RECONCILIATIONS_QUEUE_SIZE = "operator.sdk.reconciliations.queue.size.";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String GROUP = "group";
    private static final String VERSION = "version";
    private static final String KIND = "kind";
    private static final String SCOPE = "scope";
    private static final String METADATA_PREFIX = "resource.";
    private static final String CONTROLLERS_EXECUTION = "controllers.execution.";
    private static final String CONTROLLER = "controller";
    private static final String SUCCESS_SUFFIX = ".success";
    private static final String FAILURE_SUFFIX = ".failure";
    private static final String TYPE = "type";
    private static final String EXCEPTION = "exception";
    private static final String EVENT = "event";
    private static final String ACTION = "action";
    private static final String EVENTS_RECEIVED = "events.received";
    private static final String EVENTS_DELETE = "events.delete";
    private static final String CLUSTER = "cluster";
    private static final String SIZE_SUFFIX = ".size";
    private final boolean collectPerResourceMetrics;
    private final MeterRegistry registry;
    private final Map<String, AtomicInteger> gauges = new ConcurrentHashMap<String, AtomicInteger>();
    private final Cleaner cleaner;

    public static MicrometerMetrics withoutPerResourceMetrics(MeterRegistry registry) {
        return new MicrometerMetrics(registry, Cleaner.NOOP, false);
    }

    public static MicrometerMetricsBuilder newMicrometerMetricsBuilder(MeterRegistry registry) {
        return new MicrometerMetricsBuilder(registry);
    }

    public static PerResourceCollectingMicrometerMetricsBuilder newPerResourceCollectingMicrometerMetricsBuilder(MeterRegistry registry) {
        return new PerResourceCollectingMicrometerMetricsBuilder(registry);
    }

    private MicrometerMetrics(MeterRegistry registry, Cleaner cleaner, boolean collectingPerResourceMetrics) {
        this.registry = registry;
        this.cleaner = cleaner;
        this.collectPerResourceMetrics = collectingPerResourceMetrics;
    }

    public void controllerRegistered(Controller<? extends HasMetadata> controller) {
        ControllerConfiguration configuration = controller.getConfiguration();
        String name = configuration.getName();
        String executingThreadsName = RECONCILIATIONS_EXECUTIONS + name;
        Class resourceClass = configuration.getResourceClass();
        ArrayList<Tag> tags = new ArrayList<Tag>(3);
        MicrometerMetrics.addGVKTags(GroupVersionKind.gvkFor((Class)resourceClass), tags, false);
        AtomicInteger executingThreads = (AtomicInteger)this.registry.gauge(executingThreadsName, tags, (Number)new AtomicInteger(0));
        this.gauges.put(executingThreadsName, executingThreads);
        String controllerQueueName = RECONCILIATIONS_QUEUE_SIZE + name;
        AtomicInteger controllerQueueSize = (AtomicInteger)this.registry.gauge(controllerQueueName, tags, (Number)new AtomicInteger(0));
        this.gauges.put(controllerQueueName, controllerQueueSize);
    }

    public <T> T timeControllerExecution(Metrics.ControllerExecution<T> execution) {
        String name = execution.controllerName();
        String execName = "operator.sdk.controllers.execution." + execution.name();
        ResourceID resourceID = execution.resourceID();
        Map metadata = execution.metadata();
        ArrayList<Tag> tags = new ArrayList<Tag>(16);
        tags.add(Tag.of((String)CONTROLLER, (String)name));
        this.addMetadataTags(resourceID, metadata, tags, true);
        Timer timer = Timer.builder((String)execName).tags(tags).publishPercentiles(new double[]{0.3, 0.5, 0.95}).publishPercentileHistogram().register(this.registry);
        try {
            Object result = timer.record(() -> {
                try {
                    return execution.execute();
                }
                catch (Exception e) {
                    throw new OperatorException((Throwable)e);
                }
            });
            String successType = execution.successTypeName(result);
            this.registry.counter(execName + SUCCESS_SUFFIX, new String[]{CONTROLLER, name, TYPE, successType}).increment();
            return (T)result;
        }
        catch (Exception e) {
            String exception = e.getClass().getSimpleName();
            this.registry.counter(execName + FAILURE_SUFFIX, new String[]{CONTROLLER, name, EXCEPTION, exception}).increment();
            throw e;
        }
    }

    public void receivedEvent(Event event, Map<String, Object> metadata) {
        if (event instanceof ResourceEvent) {
            this.incrementCounter(event.getRelatedCustomResourceID(), EVENTS_RECEIVED, metadata, Tag.of((String)EVENT, (String)event.getClass().getSimpleName()), Tag.of((String)ACTION, (String)((ResourceEvent)event).getAction().toString()));
        } else {
            this.incrementCounter(event.getRelatedCustomResourceID(), EVENTS_RECEIVED, metadata, Tag.of((String)EVENT, (String)event.getClass().getSimpleName()));
        }
    }

    public void cleanupDoneFor(ResourceID resourceID, Map<String, Object> metadata) {
        this.incrementCounter(resourceID, EVENTS_DELETE, metadata, new Tag[0]);
        this.cleaner.removeMetersFor(resourceID);
    }

    public void reconcileCustomResource(HasMetadata resource, RetryInfo retryInfoNullable, Map<String, Object> metadata) {
        Optional<RetryInfo> retryInfo = Optional.ofNullable(retryInfoNullable);
        this.incrementCounter(ResourceID.fromResource((HasMetadata)resource), RECONCILIATIONS_STARTED, metadata, Tag.of((String)RECONCILIATIONS_RETRIES_NUMBER, (String)String.valueOf(retryInfo.map(RetryInfo::getAttemptCount).orElse(0))), Tag.of((String)RECONCILIATIONS_RETRIES_LAST, (String)String.valueOf(retryInfo.map(RetryInfo::isLastAttempt).orElse(true))));
        AtomicInteger controllerQueueSize = this.gauges.get(RECONCILIATIONS_QUEUE_SIZE + metadata.get("controller.name"));
        controllerQueueSize.incrementAndGet();
    }

    public void finishedReconciliation(HasMetadata resource, Map<String, Object> metadata) {
        this.incrementCounter(ResourceID.fromResource((HasMetadata)resource), RECONCILIATIONS_SUCCESS, metadata, new Tag[0]);
    }

    public void reconciliationExecutionStarted(HasMetadata resource, Map<String, Object> metadata) {
        AtomicInteger reconcilerExecutions = this.gauges.get(RECONCILIATIONS_EXECUTIONS + metadata.get("controller.name"));
        reconcilerExecutions.incrementAndGet();
    }

    public void reconciliationExecutionFinished(HasMetadata resource, Map<String, Object> metadata) {
        AtomicInteger reconcilerExecutions = this.gauges.get(RECONCILIATIONS_EXECUTIONS + metadata.get("controller.name"));
        reconcilerExecutions.decrementAndGet();
        AtomicInteger controllerQueueSize = this.gauges.get(RECONCILIATIONS_QUEUE_SIZE + metadata.get("controller.name"));
        controllerQueueSize.decrementAndGet();
    }

    public void failedReconciliation(HasMetadata resource, Exception exception, Map<String, Object> metadata) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            cause = exception;
        } else if (cause instanceof RuntimeException) {
            cause = cause.getCause() != null ? cause.getCause() : cause;
        }
        this.incrementCounter(ResourceID.fromResource((HasMetadata)resource), RECONCILIATIONS_FAILED, metadata, Tag.of((String)EXCEPTION, (String)cause.getClass().getSimpleName()));
    }

    public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        return (T)this.registry.gaugeMapSize(PREFIX + name + SIZE_SUFFIX, Collections.emptyList(), map);
    }

    private void addMetadataTags(ResourceID resourceID, Map<String, Object> metadata, List<Tag> tags, boolean prefixed) {
        if (this.collectPerResourceMetrics) {
            MicrometerMetrics.addTag(NAME, resourceID.getName(), tags, prefixed);
            MicrometerMetrics.addTagOmittingOnEmptyValue(NAMESPACE, resourceID.getNamespace().orElse(null), tags, prefixed);
        }
        MicrometerMetrics.addTag(SCOPE, MicrometerMetrics.getScope(resourceID), tags, prefixed);
        GroupVersionKind gvk = (GroupVersionKind)metadata.get("josdk.resource.gvk");
        if (gvk != null) {
            MicrometerMetrics.addGVKTags(gvk, tags, prefixed);
        }
    }

    private static void addTag(String name, String value, List<Tag> tags, boolean prefixed) {
        tags.add(Tag.of((String)MicrometerMetrics.getPrefixedMetadataTag(name, prefixed), (String)value));
    }

    private static void addTagOmittingOnEmptyValue(String name, String value, List<Tag> tags, boolean prefixed) {
        if (value != null && !value.isBlank()) {
            MicrometerMetrics.addTag(name, value, tags, prefixed);
        }
    }

    private static String getPrefixedMetadataTag(String tagName, boolean prefixed) {
        return prefixed ? METADATA_PREFIX + tagName : tagName;
    }

    private static String getScope(ResourceID resourceID) {
        return resourceID.getNamespace().isPresent() ? NAMESPACE : CLUSTER;
    }

    private static void addGVKTags(GroupVersionKind gvk, List<Tag> tags, boolean prefixed) {
        MicrometerMetrics.addTagOmittingOnEmptyValue(GROUP, gvk.getGroup(), tags, prefixed);
        MicrometerMetrics.addTag(VERSION, gvk.getVersion(), tags, prefixed);
        MicrometerMetrics.addTag(KIND, gvk.getKind(), tags, prefixed);
    }

    private void incrementCounter(ResourceID id, String counterName, Map<String, Object> metadata, Tag ... additionalTags) {
        int additionalTagsNb = additionalTags != null && additionalTags.length > 0 ? additionalTags.length : 0;
        int metadataNb = metadata != null ? metadata.size() : 0;
        ArrayList<Tag> tags = new ArrayList<Tag>(6 + additionalTagsNb + metadataNb);
        this.addMetadataTags(id, metadata, tags, false);
        if (additionalTagsNb > 0) {
            tags.addAll(List.of(additionalTags));
        }
        Counter counter = this.registry.counter(PREFIX + counterName, tags);
        this.cleaner.recordAssociation(id, (Meter)counter);
        counter.increment();
    }

    protected Set<Meter.Id> recordedMeterIdsFor(ResourceID resourceID) {
        return this.cleaner.recordedMeterIdsFor(resourceID);
    }

    static interface Cleaner {
        public static final Cleaner NOOP = new Cleaner(){};

        default public void removeMetersFor(ResourceID resourceID) {
        }

        default public void recordAssociation(ResourceID resourceID, Meter meter) {
        }

        default public Set<Meter.Id> recordedMeterIdsFor(ResourceID resourceID) {
            return Collections.emptySet();
        }
    }

    public static class MicrometerMetricsBuilder {
        protected final MeterRegistry registry;
        private boolean collectingPerResourceMetrics = true;

        private MicrometerMetricsBuilder(MeterRegistry registry) {
            this.registry = registry;
        }

        public PerResourceCollectingMicrometerMetricsBuilder collectingMetricsPerResource() {
            this.collectingPerResourceMetrics = true;
            return new PerResourceCollectingMicrometerMetricsBuilder(this.registry);
        }

        public MicrometerMetricsBuilder notCollectingMetricsPerResource() {
            this.collectingPerResourceMetrics = false;
            return this;
        }

        public MicrometerMetrics build() {
            return new MicrometerMetrics(this.registry, Cleaner.NOOP, this.collectingPerResourceMetrics);
        }
    }

    public static class PerResourceCollectingMicrometerMetricsBuilder
    extends MicrometerMetricsBuilder {
        private int cleaningThreadsNumber;
        private int cleanUpDelayInSeconds;

        private PerResourceCollectingMicrometerMetricsBuilder(MeterRegistry registry) {
            super(registry);
        }

        public PerResourceCollectingMicrometerMetricsBuilder withCleaningThreadNumber(int cleaningThreadsNumber) {
            this.cleaningThreadsNumber = cleaningThreadsNumber <= 0 ? 1 : cleaningThreadsNumber;
            return this;
        }

        public PerResourceCollectingMicrometerMetricsBuilder withCleanUpDelayInSeconds(int cleanUpDelayInSeconds) {
            this.cleanUpDelayInSeconds = Math.max(cleanUpDelayInSeconds, 1);
            return this;
        }

        @Override
        public MicrometerMetrics build() {
            DelayedCleaner cleaner = new DelayedCleaner(this.registry, this.cleanUpDelayInSeconds, this.cleaningThreadsNumber);
            return new MicrometerMetrics(this.registry, cleaner, true);
        }
    }

    static class DelayedCleaner
    extends DefaultCleaner {
        private final ScheduledExecutorService metersCleaner;
        private final int cleanUpDelayInSeconds;

        private DelayedCleaner(MeterRegistry registry, int cleanUpDelayInSeconds, int cleaningThreadsNumber) {
            super(registry);
            this.cleanUpDelayInSeconds = cleanUpDelayInSeconds;
            this.metersCleaner = Executors.newScheduledThreadPool(cleaningThreadsNumber);
        }

        @Override
        public void removeMetersFor(ResourceID resourceID) {
            this.metersCleaner.schedule(() -> super.removeMetersFor(resourceID), (long)this.cleanUpDelayInSeconds, TimeUnit.SECONDS);
        }
    }

    static class DefaultCleaner
    implements Cleaner {
        private final Map<ResourceID, Set<Meter.Id>> metersPerResource = new ConcurrentHashMap<ResourceID, Set<Meter.Id>>();
        private final MeterRegistry registry;

        private DefaultCleaner(MeterRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void removeMetersFor(ResourceID resourceID) {
            Set<Meter.Id> toClean = this.metersPerResource.get(resourceID);
            if (toClean != null) {
                toClean.forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
            }
            this.metersPerResource.remove(resourceID);
        }

        @Override
        public void recordAssociation(ResourceID resourceID, Meter meter) {
            this.metersPerResource.computeIfAbsent(resourceID, id -> new HashSet()).add(meter.getId());
        }

        @Override
        public Set<Meter.Id> recordedMeterIdsFor(ResourceID resourceID) {
            return this.metersPerResource.get(resourceID);
        }
    }
}

