/*
 * Decompiled with CFR 0.152.
 */
package io.iteratee.testing.files;

import cats.Monad;
import cats.syntax.EqOps;
import io.iteratee.Enumerator;
import io.iteratee.files.modules.FileModule;
import io.iteratee.modules.EnumeratorModule;
import io.iteratee.modules.IterateeModule;
import io.iteratee.modules.Module;
import io.iteratee.testing.ModuleSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen$;
import org.scalacheck.Shrink$;
import org.scalacheck.util.Buildable$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.prop.Configuration;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.immutable.Vector;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005!3aa\u0001\u0003\u0002\u00025\t\u0004\u0002\u0003\u0013\u0001\u0005\u0007\u0005\u000b1B\u0013\t\u000b-\u0002A\u0011\u0001\u0017\u0003\u001f\u0019KG.Z'pIVdWmU;ji\u0016T!!\u0002\u0004\u0002\u000b\u0019LG.Z:\u000b\u0005\u001dA\u0011a\u0002;fgRLgn\u001a\u0006\u0003\u0013)\t\u0001\"\u001b;fe\u0006$X-\u001a\u0006\u0002\u0017\u0005\u0011\u0011n\\\u0002\u0001+\tqQc\u0005\u0002\u0001\u001fA\u0019\u0001#E\n\u000e\u0003\u0019I!A\u0005\u0004\u0003\u00175{G-\u001e7f'VLG/\u001a\t\u0003)Ua\u0001\u0001B\u0003\u0017\u0001\t\u0007qCA\u0001G+\tA\"%\u0005\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t9aj\u001c;iS:<\u0007C\u0001\u000e!\u0013\t\t3DA\u0002B]f$QaI\u000bC\u0002a\u0011\u0011aX\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001\u0014*'5\tqEC\u0001)\u0003\u0011\u0019\u0017\r^:\n\u0005):#!B'p]\u0006$\u0017A\u0002\u001fj]&$h\bF\u0001.)\tq\u0003\u0007E\u00020\u0001Mi\u0011\u0001\u0002\u0005\u0006I\t\u0001\u001d!\n\n\u0004e9\"d\u0001B\u001a\u0001\u0001E\u0012A\u0002\u0010:fM&tW-\\3oiz\u0012R!\u000e\u001c=\u007f\t3Aa\r\u0001\u0001iA\u0019qGO\n\u000e\u0003aR!!\u000f\u0005\u0002\u000f5|G-\u001e7fg&\u00111\b\u000f\u0002\u0007\u001b>$W\u000f\\3\u0011\u0007]j4#\u0003\u0002?q\t\u0001RI\\;nKJ\fGo\u001c:N_\u0012,H.\u001a\t\u0004o\u0001\u001b\u0012BA!9\u00059IE/\u001a:bi\u0016,Wj\u001c3vY\u0016\u00042a\u0011$\u0014\u001b\u0005!%BA\u001dF\u0015\t)\u0001\"\u0003\u0002H\t\nQa)\u001b7f\u001b>$W\u000f\\3")
public abstract class FileModuleSuite<F>
extends ModuleSuite<F> {
    private final Monad<F> evidence$1;

    public FileModuleSuite(Monad<F> evidence$1) {
        this.evidence$1 = evidence$1;
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readLines", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 14)).should("enumerate text lines from a file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
            Enumerator enumerator = ((FileModule)this).readLines(txt).flatMap((Function1 & Serializable)line -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapRefArray((Object[])line.trim().split("\\s+")).toVector()), $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForLong()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)17973L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 18));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 14));
        this.it().should("work with an iteratee that stops early").in((Function0 & Serializable)() -> {
            File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
            String result = "The Project Gutenberg EBook of Bartleby, The Scrivener, by Herman Melville";
            Enumerator enumerator = ((FileModule)this).readLines(txt);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).head(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForOption(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)new Some((Object)result));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 21));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readLinesFromStream", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29)).should("enumerate text lines from a stream", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
            FileInputStream stream = new FileInputStream(txt);
            Enumerator enumerator = ((FileModule)this).readLinesFromStream((InputStream)stream).flatMap((Function1 & Serializable)line -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapRefArray((Object[])line.trim().split("\\s+")).toVector()), $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForLong()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)17973L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readBytes", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37)).should("enumerate bytes from a file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File txt = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
            Enumerator enumerator = ((FileModule)this).readBytes(txt).flatMap((Function1 & Serializable)bytes -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapByteArray(bytes).toVector()), $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForLong()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)105397L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readBytesFromStream", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44)).should("enumerate bytes from a stream", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
            Enumerator enumerator = ((FileModule)this).readZipStreams(zip).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                InputStream stream = (InputStream)tuple2._2();
                Enumerator enumerator = ((FileModule)this).readBytesFromStream(stream);
                return enumerator;
            }, $this.evidence$1).flatMap((Function1 & Serializable)bytes -> ((EnumeratorModule)this).enumVector(Predef$.MODULE$.wrapByteArray(bytes).toVector()), $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForLong()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)105397L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("readZipStreams", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53)).should("enumerate files in a zip archive", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
            Enumerator enumerator = ((FileModule)this).readZipStreams(zip).flatMap((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                InputStream stream = (InputStream)tuple2._2();
                Enumerator enumerator = ((FileModule)this).readLinesFromStream(stream);
                return enumerator;
            }, $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).length(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForLong()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToLong((long)1981L));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.it().should("work with an iteratee that stops early").in((Function0 & Serializable)() -> {
            File zip = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.zip").toURI());
            Enumerator enumerator = ((FileModule)this).readZipStreams(zip).map((Function1 & Serializable)x$1 -> ((ZipEntry)x$1._1()).getName(), $this.evidence$1);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(enumerator.into(((IterateeModule)this).head(), $this.evidence$1), this.eqF(this.catsKernelStdOrderForOption(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)new Some((Object)"11231.txt"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("listFiles", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70)).should("enumerate files in a directory", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File dir = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231").toURI());
            Vector result = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11231.txt", "11231.zip"}));
            Enumerator enumerator = ((FileModule)this).listFiles(dir);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector($this.evidence$1), (Function1 & Serializable)x$2 -> (Vector)((StrictOptimizedSeqOps)x$2.map((Function1 & Serializable)x$3 -> x$3.getName())).sorted(this.catsKernelOrderingForOrder(this.catsKernelStdOrderForString()))), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)result);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.it().should("fail properly on a file").in((Function0 & Serializable)() -> {
            File notDir = new File(this.getClass().getResource("/io/iteratee/examples/pg/11231/11231.txt").toURI());
            Enumerator enumerator = ((FileModule)this).listFiles(notDir);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector($this.evidence$1), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty())), this.eqF(this.catsKernelStdOrderForBoolean()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("listFilesRec", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85)).should("enumerate files in a directory recursively", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> {
            File dir = new File(this.getClass().getResource("/io/iteratee/examples/pg").toURI());
            Vector result = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11231.txt", "11231.zip"}));
            Enumerator enumerator = ((FileModule)this).listFilesRec(dir);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((Module)this).F().map(enumerator.toVector($this.evidence$1), (Function1 & Serializable)x$5 -> (Vector)((StrictOptimizedSeqOps)x$5.map((Function1 & Serializable)x$6 -> x$6.getName())).sorted(this.catsKernelOrderingForOrder(this.catsKernelStdOrderForString()))), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)result);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeLines", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)).should("write arbitrary lines to a temporary file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> (Assertion)this.forAll(Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.alphaStr()), (Seq<Configuration.PropertyCheckConfigParam>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1 & Serializable)lines -> {
            File tmp = File.createTempFile("it-writeLines", ".txt");
            tmp.deleteOnExit();
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((EnumeratorModule)this).enumList(lines).into(((FileModule)this).writeLines(tmp), $this.evidence$1), this.eqF(this.catsKernelStdOrderForUnit()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            EqOps<Object> $org_scalatest_assert_macro_left2 = this.catsSyntaxEq(((FileModule)this).readLines(tmp).toVector($this.evidence$1), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right2 = ((Module)this).F().pure((Object)lines.toVector());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkString(), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeLinesToStream", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101)).should("write arbitrary lines to a temporary file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> (Assertion)this.forAll(Gen$.MODULE$.listOf((Function0 & Serializable)() -> Gen$.MODULE$.alphaStr()), (Seq<Configuration.PropertyCheckConfigParam>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1 & Serializable)lines -> {
            File tmp = File.createTempFile("it-writeLinesToStream", ".txt");
            tmp.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(tmp);
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((EnumeratorModule)this).enumList(lines).into(((FileModule)this).writeLinesToStream((OutputStream)stream), $this.evidence$1), this.eqF(this.catsKernelStdOrderForUnit()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            EqOps<Object> $org_scalatest_assert_macro_left2 = this.catsSyntaxEq(((FileModule)this).readLines(tmp).toVector($this.evidence$1), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForString())));
            Object $org_scalatest_assert_macro_right2 = ((Module)this).F().pure((Object)lines.toVector());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        }, this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkString(), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101)), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeBytes", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110)).should("write arbitrary bytes to a temporary file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> (Assertion)this.forAll((Function1 & Serializable)bytes -> {
            File tmp = File.createTempFile("it-writeBytes", ".txt");
            tmp.deleteOnExit();
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((EnumeratorModule)this).enumList(bytes).into(((FileModule)this).writeBytes(tmp), $this.evidence$1), this.eqF(this.catsKernelStdOrderForUnit()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            EqOps<Object> $org_scalatest_assert_macro_left2 = this.catsSyntaxEq(this.toFunctorOps(((FileModule)this).readBytes(tmp).toVector($this.evidence$1), $this.evidence$1).map((Function1 & Serializable)x$7 -> (Vector)x$7.flatMap((Function1 & Serializable)x$8 -> Predef$.MODULE$.wrapByteArray(x$8).toVector())), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForByte())));
            Object $org_scalatest_assert_macro_right2 = ((Module)this).F().pure(bytes.toVector().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbByte(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkContainer((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte()))), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110)), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.convertToInAndIgnoreMethods(this.convertToStringShouldWrapperForVerb("writeBytesToStream", new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118)).should("write arbitrary bytes to a temporary file", this.shorthandTestRegistrationFunction())).in((Function0 & Serializable)() -> (Assertion)this.forAll((Function1 & Serializable)bytes -> {
            File tmp = File.createTempFile("it-writeBytesToStream", ".txt");
            tmp.deleteOnExit();
            EqOps<Object> $org_scalatest_assert_macro_left = this.catsSyntaxEq(((EnumeratorModule)this).enumList(bytes).into(((FileModule)this).writeBytes(tmp), $this.evidence$1), this.eqF(this.catsKernelStdOrderForUnit()));
            Object $org_scalatest_assert_macro_right = ((Module)this).F().pure((Object)BoxedUnit.UNIT);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            EqOps<Object> $org_scalatest_assert_macro_left2 = this.catsSyntaxEq(this.toFunctorOps(((FileModule)this).readBytes(tmp).toVector($this.evidence$1), $this.evidence$1).map((Function1 & Serializable)x$9 -> (Vector)x$9.flatMap((Function1 & Serializable)x$10 -> Predef$.MODULE$.wrapByteArray(x$10).toVector())), this.eqF(this.catsKernelStdOrderForVector(this.catsKernelStdOrderForByte())));
            Object $org_scalatest_assert_macro_right2 = ((Module)this).F().pure(bytes.toVector().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, this.generatorDrivenConfig(), Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbContainer(Arbitrary$.MODULE$.arbByte(), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte())), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs)), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkContainer((Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), Buildable$.MODULE$.buildableFactory(Factory$.MODULE$.arrayFactory((ClassTag)ClassTag$.MODULE$.Byte()))), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118)), new Position("FileModuleSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }
}

