/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Collection;
import io.inversion.Property;
import io.inversion.query.Projection;
import io.inversion.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Index
implements Serializable {
    public static final String TYPE_INDEX = "INDEX";
    public static final String TYPE_RESOURCE_KEY = "RESOURCE_KEY";
    public static final String TYPE_PRIMARY_KEY = "PRIMARY_KEY";
    public static final String TYPE_FOREIGN_KEY = "FOREIGN_KEY";
    protected final List<Property> properties = new ArrayList<Property>();
    protected Collection collection = null;
    protected String name = null;
    protected String type = null;
    protected boolean unique = true;
    protected Projection projection = null;

    public Index() {
    }

    public Index(String name, String type, boolean unique, Property ... properties) {
        this.withName(name);
        this.withType(type);
        this.withUnique(unique);
        this.withProperties(properties);
    }

    public Index(String name, String type, boolean unique, int sequence, Property property) {
        this.withName(name);
        this.withType(type);
        this.withUnique(unique);
        this.withProperty(sequence, property);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Index) {
            Index index = (Index)object;
            return (this.collection == null || this.collection == index.collection) && Utils.equal((Object)this.name, (Object)index.name);
        }
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[Index: ").append(this.collection == null ? null : this.collection.getName()).append(":").append(this.name).append("(");
        for (int i = 0; i < this.size(); ++i) {
            buff.append(this.getJsonName(i));
            if (i >= this.size() - 1) continue;
            buff.append(", ");
        }
        buff.append(")]");
        return buff.toString();
    }

    public boolean isExclude() {
        if (this.collection.isExclude()) {
            return true;
        }
        for (Property property : this.properties) {
            if (!property.isExclude()) continue;
            return true;
        }
        return false;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Index withCollection(Collection coll) {
        if (this.collection != coll) {
            this.collection = coll;
            coll.withIndexes(this);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Index withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Index withType(String type) {
        this.type = type;
        return this;
    }

    public boolean isType(String ... types) {
        for (String type : types) {
            if (!type.equalsIgnoreCase(this.type)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Index withUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public int size() {
        return this.properties.size();
    }

    public Index withProperty(int sequence, Property property) {
        if (!this.properties.contains(property)) {
            if (sequence > 0) {
                while (this.properties.size() < sequence) {
                    this.properties.add(null);
                }
                this.properties.set(sequence - 1, property);
            } else {
                this.properties.add(property);
            }
        }
        return this;
    }

    public Index withProperties(Property ... properties) {
        for (int i = 0; properties != null && i < properties.length; ++i) {
            if (properties[i] == null || this.properties.contains(properties[i])) continue;
            this.properties.add(properties[i]);
        }
        return this;
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.properties);
    }

    public Property getProperty(int idx) {
        return this.properties.get(idx);
    }

    public String getColumnName(int index) {
        return index < this.properties.size() ? this.properties.get(index).getColumnName() : null;
    }

    public List<String> getColumnNames() {
        return this.properties.stream().map(Property::getColumnName).collect(Collectors.toList());
    }

    public String getJsonName(int index) {
        return index < this.properties.size() ? this.properties.get(index).getJsonName() : null;
    }

    public List<String> getJsonNames() {
        return this.properties.stream().map(Property::getJsonName).collect(Collectors.toList());
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Index withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }
}

