/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Filter;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import io.inversion.action.security.AuthScheme;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AuthFilter
extends Filter<AuthFilter> {
    public static final int AUTH_ACTION_DEFAULT_ORDER_IS_100 = 100;
    protected List<AuthScheme> schemes = new ArrayList<AuthScheme>();

    public AuthFilter() {
        this.withOrder(100);
    }

    @Override
    public void run(Request req, Response resp) throws ApiException {
        User user = Chain.getUser();
        if (user == null) {
            AuthScheme scheme;
            Iterator<AuthScheme> iterator = this.schemes.iterator();
            while (iterator.hasNext() && (user = (scheme = iterator.next()).getUser(req, resp)) == null) {
            }
        }
        if (user == null) {
            throw ApiException.new401Unauthroized();
        }
        Chain.peek().withUser(user);
    }

    public List<AuthScheme> getAuthSchemes() {
        return this.schemes;
    }

    public AuthFilter withAuthSchemes(List<AuthScheme> schemes) {
        schemes.forEach(this::withAuthScheme);
        return this;
    }

    public AuthFilter withAuthScheme(AuthScheme scheme) {
        if (scheme != null && !this.schemes.contains(scheme)) {
            this.schemes.add(scheme);
        }
        return this;
    }
}

