/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.misc;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.Path;
import io.inversion.utils.StreamBuffer;
import io.inversion.utils.Utils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class FileAction<A extends FileAction>
extends Action<A> {
    protected String baseDir = null;
    protected Set<String> files = new HashSet<String>();

    @Override
    public void doGet(Request req, Response res) throws ApiException {
        this.serveFile(req, res);
    }

    protected void serveFile(Request req, Response res) {
        boolean filterMode = req.getOp() == null;
        Path path = req.getOperationPath();
        String filePath = null;
        if (path == null) {
            path = req.getUrl().getPath();
            filePath = path.last();
        } else {
            filePath = path.toString();
        }
        this.serveFile(req, res, filePath, filterMode);
    }

    protected void serveFile(Request req, Response res, String filePath, boolean filterMode) {
        InputStream is;
        if (filePath != null && (is = this.findStream(filePath)) != null) {
            res.withBody(new StreamBuffer(is));
            if (filterMode) {
                req.getChain().cancel();
            }
            return;
        }
        if (!filterMode) {
            throw ApiException.new404NotFound("File '{}' could not be found", filePath);
        }
    }

    protected InputStream findStream(String filePath) {
        if (this.baseDir != null) {
            filePath = new Path(new String[]{this.baseDir, filePath}).toString();
        }
        return Utils.findInputStream((Object)this, (String[])new String[]{filePath});
    }

    public boolean canServe(String filePath) {
        if (filePath == null) {
            return false;
        }
        String fullPath = filePath = new Path(new String[]{filePath}).toString();
        if (this.baseDir != null) {
            fullPath = new Path(new String[]{this.baseDir, fullPath}).toString();
        }
        return this.files.size() <= 0 || this.files.contains(fullPath.toLowerCase()) || this.files.contains(filePath.toLowerCase());
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public FileAction withBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public FileAction withFiles(String ... files) {
        for (String file : files) {
            this.files.add(file.toLowerCase());
        }
        return this;
    }
}

