/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Collection;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Request;
import io.inversion.Url;
import io.inversion.utils.Path;
import java.util.ArrayList;

public class Linker {
    protected String name = null;

    public String buildLink(Request req, String collectionName, String resourceKey, String relationshipKey) {
        return this.buildLink(req, req.getApi().getCollection(collectionName), resourceKey, relationshipKey);
    }

    public String buildLink(Request req, Collection collection, String resourceKey, String relationshipKey) {
        ArrayList found = new ArrayList();
        for (Op op : req.getApi().getOps()) {
            if (op.getCollection() != collection || (resourceKey != null ? (relationshipKey != null ? op.getFunction() != Op.OpFunction.RELATED : op.getFunction() != Op.OpFunction.GET) : op.getFunction() != Op.OpFunction.FIND)) continue;
            Path opPath = new Path(op.getPath());
            for (Param p : op.getParams()) {
                if (p.getIn() != Param.In.PATH) continue;
                if (p.getKey().equalsIgnoreCase("_collection")) {
                    opPath.set(p.getIndex(), collection.getName());
                    continue;
                }
                if (p.getKey().equalsIgnoreCase("_resource")) {
                    opPath.set(p.getIndex(), resourceKey);
                    continue;
                }
                if (p.getKey().equalsIgnoreCase("_relationship")) {
                    opPath.set(p.getIndex(), relationshipKey);
                    continue;
                }
                String matchingParam = req.findParam(p.getKey(), Param.In.PATH);
                if (matchingParam == null) continue;
                opPath.set(p.getIndex(), matchingParam);
            }
            for (int i = 0; i < opPath.size(); ++i) {
                if (!opPath.isVar(i)) continue;
                opPath = null;
                break;
            }
            if (opPath == null) continue;
            Path serverPath = new Path(req.getServerPath());
            Url url = req.getUrl();
            Object link = "";
            Path path = new Path(new String[]{req.getServerPath().toString(), opPath.toString()});
            link = (String)link + "/" + path;
            return link;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Linker withName(String name) {
        this.name = name;
        return this;
    }
}

