/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security;

import io.inversion.ApiException;
import io.inversion.Param;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import java.util.ArrayList;
import java.util.List;

public abstract class AuthScheme {
    String name = null;
    String description = null;
    AuthSchemeType type = null;
    List<Param> params = new ArrayList<Param>();

    public abstract User getUser(Request var1, Response var2) throws ApiException;

    public String getName() {
        return this.name;
    }

    public AuthScheme withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AuthScheme withDescription(String description) {
        this.description = description;
        return this;
    }

    public AuthSchemeType getType() {
        return this.type;
    }

    public AuthScheme withType(AuthSchemeType type) {
        this.type = type;
        return this;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public AuthScheme withParams(List<Param> params) {
        this.params = params;
        return this;
    }

    public AuthScheme withParam(Param param) {
        if (param != null && !this.params.contains(param)) {
            this.params.add(param);
        }
        return this;
    }

    public static enum AuthSchemeType {
        http,
        apiKey,
        openIdConnect,
        oauth2;

    }
}

