/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Param;
import io.inversion.context.Context;
import io.inversion.json.JSMap;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Rule<R extends Rule>
implements Comparable<R> {
    public static final SortedSet<String> ALL_METHODS = Collections.unmodifiableSortedSet(new TreeSet(Utils.asSet((Object[])new Object[]{"GET", "POST", "PUT", "PATCH", "DELETE"})));
    protected final transient Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final List<RuleMatcher> includeMatchers = new ArrayList<RuleMatcher>();
    protected final List<RuleMatcher> excludeMatchers = new ArrayList<RuleMatcher>();
    protected final transient JSMap configMap = new JSMap();
    protected String name = null;
    protected int order = 1000;
    protected String includeOn = null;
    protected String excludeOn = null;
    protected String description = null;
    protected List<Param> params = new ArrayList<Param>();
    transient boolean lazyConfiged = false;

    static List<Path> asPathsList(String ... paths) {
        ArrayList<Path> pathsList = new ArrayList<Path>();
        for (String path : Utils.explode((String)",", (String[])paths)) {
            pathsList.add(new Path(new String[]{path}));
        }
        if (pathsList.size() == 0) {
            pathsList.add(new Path(new String[]{"*"}));
        }
        return pathsList;
    }

    static Path[] asPathsArray(String ... paths) {
        List<Path> list = Rule.asPathsList(paths);
        return list.toArray(new Path[0]);
    }

    public void afterWiringComplete(Context context) {
        this.checkLazyConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLazyConfig() {
        if (!this.lazyConfiged) {
            Rule rule = this;
            synchronized (rule) {
                if (!this.lazyConfiged) {
                    this.lazyConfiged = true;
                    this.doLazyConfig();
                }
            }
        }
    }

    protected void doLazyConfig() {
        if (this.includeOn != null) {
            this.withIncludeOn(this.includeOn);
        }
        if (this.excludeOn != null) {
            this.withExcludeOn(this.excludeOn);
        }
        if (this.includeMatchers.size() == 0 && this.excludeMatchers.size() == 0) {
            List<RuleMatcher> matchers = this.getDefaultIncludeMatchers();
            for (RuleMatcher m : matchers) {
                this.withIncludeOn(m);
            }
        }
    }

    protected List<RuleMatcher> getDefaultIncludeMatchers() {
        return Utils.asList((Object[])new Object[]{new RuleMatcher(null, "*")});
    }

    public boolean matches(String method, String path) {
        return this.matches(method, new Path(new String[]{path}));
    }

    public boolean matches(String method, Path path) {
        return this.match(method, path) != null;
    }

    public Path match(String method, Path path) {
        return this.match(method, path, false);
    }

    public Path match(String method, Path path, boolean bidirectional) {
        this.checkLazyConfig();
        for (RuleMatcher excluder : this.excludeMatchers) {
            if (excluder.methods.size() > 0 && !excluder.methods.contains(method)) continue;
            for (Path excludePath : excluder.paths) {
                if (!excludePath.matches(path, bidirectional)) continue;
                return null;
            }
        }
        int includePathCount = 0;
        for (RuleMatcher includer : this.includeMatchers) {
            includePathCount += includer.paths.size();
            if (includer.methods.size() > 0 && !includer.methods.contains(method)) continue;
            for (Path includePath : includer.paths) {
                if (!includePath.matches(path, bidirectional)) continue;
                return includePath;
            }
        }
        if (includePathCount == 0) {
            return new Path(new String[]{"*"});
        }
        return null;
    }

    public List<String> getAllIncludeMethods() {
        this.checkLazyConfig();
        LinkedHashSet<String> methods = new LinkedHashSet<String>();
        for (RuleMatcher includer : this.includeMatchers) {
            methods.addAll(includer.methods);
        }
        return new ArrayList<String>(methods);
    }

    public List<Path> getAllIncludePaths() {
        this.checkLazyConfig();
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (RuleMatcher includer : this.includeMatchers) {
            paths.addAll(includer.paths);
        }
        return new ArrayList<Path>(paths);
    }

    public List<Path> getAllExcludePaths() {
        this.checkLazyConfig();
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (RuleMatcher excluder : this.excludeMatchers) {
            paths.addAll(excluder.paths);
        }
        return new ArrayList<Path>(paths);
    }

    public List<RuleMatcher> getIncludeMatchers() {
        this.checkLazyConfig();
        return new ArrayList<RuleMatcher>(this.includeMatchers);
    }

    public R withIncludeOn(RuleMatcher matcher) {
        this.includeMatchers.add(matcher);
        return (R)this;
    }

    public R withIncludeOn(String ... specs) {
        for (int i = 0; specs != null && i < specs.length; ++i) {
            this.withIncludeOn(new RuleMatcher(specs[i]));
        }
        return (R)this;
    }

    public R withExcludeOn(RuleMatcher matcher) {
        this.excludeMatchers.add(matcher);
        return (R)this;
    }

    public R withExcludeOn(String ... specs) {
        for (int i = 0; specs != null && i < specs.length; ++i) {
            this.withExcludeOn(new RuleMatcher(specs[i]));
        }
        return (R)this;
    }

    public List<RuleMatcher> getExcludeMatchers() {
        this.checkLazyConfig();
        return new ArrayList<RuleMatcher>(this.excludeMatchers);
    }

    public String getName() {
        return this.name;
    }

    public R withName(String name) {
        this.name = name;
        return (R)this;
    }

    public Rule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public R withOrder(int order) {
        this.order = order;
        return (R)this;
    }

    @Override
    public int compareTo(Rule a) {
        int compare = Integer.compare(this.getOrder(), a.getOrder());
        return compare;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public R withParams(List<Param> params) {
        params.forEach(p -> this.withParam((Param)p));
        return (R)this;
    }

    public R withParam(Param param) {
        if (!this.params.contains(param)) {
            this.params.add(param);
        }
        return (R)this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.getClass().getSimpleName());
        if (this.name != null) {
            buff.append(":").append(this.name);
        }
        if (this.includeMatchers.size() > 0 || this.excludeMatchers.size() > 0) {
            buff.append(" -");
            if (this.includeMatchers.size() > 0) {
                buff.append(" includes: ").append(this.includeMatchers);
            }
            if (this.excludeMatchers.size() > 0) {
                buff.append(" exclude: ").append(this.excludeMatchers);
            }
        }
        return buff.toString();
    }

    public static class RuleMatcher {
        protected final TreeSet<String> methods = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        protected final LinkedHashSet<Path> paths = new LinkedHashSet();

        public RuleMatcher() {
        }

        public RuleMatcher(String spec) {
            RuleMatcher.parse(this, spec);
        }

        public static void parse(RuleMatcher matcher, String spec) {
            if (spec == null) {
                return;
            }
            spec = spec.trim();
            List parts = Utils.explode((String)",", (String[])new String[]{spec});
            for (String part : parts) {
                if (ALL_METHODS.contains(part.toUpperCase())) {
                    matcher.withMethods(part);
                    continue;
                }
                matcher.withPaths(new Path(new String[]{part}));
            }
        }

        public String toString() {
            return Utils.implode((String)",", (Object[])new Object[]{this.methods, this.paths});
        }

        public int hashCode() {
            return this.toString().toLowerCase().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof RuleMatcher && Utils.equal((Object)this.toString(), (Object)o.toString());
        }

        public RuleMatcher(String methods, String ... paths) {
            this(methods, Rule.asPathsList(paths));
        }

        public RuleMatcher(String methods, Path path) {
            this.withMethods(methods);
            this.withPaths(path);
        }

        public RuleMatcher(String methods, List<Path> paths) {
            this.withMethods(methods);
            this.withPaths(paths);
        }

        public RuleMatcher clearPaths() {
            this.paths.clear();
            return this;
        }

        public RuleMatcher clearMethods() {
            this.methods.clear();
            return this;
        }

        public boolean hasMethod(String method) {
            return this.methods.size() == 0 || this.methods.contains(method);
        }

        public void withMethods(String ... methods) {
            for (String method : Utils.explode((String)",", (String[])methods)) {
                if (method.equals("*") || !ALL_METHODS.contains(method = method.toUpperCase())) continue;
                this.methods.add(method);
            }
        }

        public RuleMatcher withPaths(Path ... paths) {
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (paths[i] == null) continue;
                this.paths.add(paths[i]);
            }
            return this;
        }

        public RuleMatcher withPaths(List<Path> paths) {
            for (Path p : paths) {
                this.withPaths(p);
            }
            return this;
        }

        public SortedSet<String> getMethods() {
            if (this.methods.size() == 0) {
                return ALL_METHODS;
            }
            return Collections.unmodifiableSortedSet(this.methods);
        }

        public LinkedHashSet<Path> getPaths() {
            if (this.paths.size() == 0) {
                return (LinkedHashSet)Utils.add(new LinkedHashSet(), (Object[])new Object[]{new Path(new String[]{"*"})});
            }
            return new LinkedHashSet<Path>(this.paths);
        }
    }
}

