/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Engine;
import io.inversion.Param;
import io.inversion.Relationship;
import io.inversion.Request;
import io.inversion.Rule;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public final class Op
implements Comparable<Op> {
    String name = null;
    String method = null;
    Path path = null;
    String description = null;
    boolean internal = false;
    OpFunction function = null;
    Engine engine = null;
    Api api = null;
    Endpoint endpoint = null;
    Path endpointPathMatch = null;
    Path actionPathMatch = null;
    List<Triple<Action, Path, Boolean>> actionPathMatches = new ArrayList<Triple<Action, Path, Boolean>>();
    Db db = null;
    Path dbPathMatch = null;
    Collection collection = null;
    Path collectionPathMatch = null;
    Relationship relationship = null;
    List<Param> params = new ArrayList<Param>();

    public boolean matches(Request req, Path path) {
        if (!this.getMethod().equalsIgnoreCase(req.getMethod())) {
            return false;
        }
        if (!this.getPath().matches(path)) {
            return false;
        }
        if (!this.getEndpoint().matches(req.getMethod(), path)) {
            return false;
        }
        for (Param param : this.getParams()) {
            if (param.in != Param.In.PATH) continue;
            for (Pattern regex : param.getPatterns()) {
                if (regex.matcher(path.get(param.getIndex())).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public String getOperationPath() {
        return "/" + this.path;
    }

    public boolean isInternal() {
        return this.internal || this.endpoint != null && this.endpoint.isInternal() || this.collection != null && this.collection.isLinkTbl();
    }

    public Op withInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public String toString() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.getName());
        props.put("method", this.getMethod());
        props.put("path", this.getPath());
        props.put("collection", this.collection != null ? this.collection.getName() : null);
        props.put("relationship", this.relationship != null ? this.relationship.getName() : null);
        ArrayList<String> actStr = new ArrayList<String>();
        for (Action action : this.getActions()) {
            actStr.add(this.getActionNameString(action));
        }
        props.put("actions", actStr);
        props.put("params", this.getParams());
        String str = props.toString();
        return str;
    }

    String getActionNameString(Action action) {
        String name = action.getName();
        if (name == null && (name = action.getClass().getName()).indexOf(".") > 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public Path getActionPathMatch() {
        return this.actionPathMatch;
    }

    public Op withActionPathMatch(Path actionPathMatch) {
        this.actionPathMatch = actionPathMatch;
        return this;
    }

    public Op withActionMatch(Action action, Path actionMatchPath, Boolean isEpAction) {
        int i;
        this.actionPathMatches.add((Triple<Action, Path, Boolean>)new MutableTriple((Object)action, (Object)actionMatchPath, (Object)isEpAction));
        int offset = 0;
        if (isEpAction.booleanValue()) {
            for (i = 0; i < this.endpointPathMatch.size() && !this.endpointPathMatch.isOptional(i) && !this.endpointPathMatch.isWildcard(i); ++i) {
                ++offset;
            }
        }
        for (i = 0; i < actionMatchPath.size() && offset + i < this.path.size(); ++i) {
            if (!actionMatchPath.isVar(i)) continue;
            Param p = new Param();
            p.withIn(Param.In.PATH);
            p.withIndex(i + offset);
            p.withKey(actionMatchPath.getVarName(i));
            String regex = actionMatchPath.getRegex(i);
            if (regex != null) {
                p.withRegex(regex);
            }
            this.withParam(p);
        }
        Collections.sort(this.actionPathMatches, new Comparator<Triple<Action, Path, Boolean>>(){

            @Override
            public int compare(Triple<Action, Path, Boolean> o1, Triple<Action, Path, Boolean> o2) {
                return ((Action)o1.getLeft()).compareTo((Rule)o2.getLeft());
            }
        });
        return this;
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Triple<Action, Path, Boolean> actionPathMatch : this.actionPathMatches) {
            actions.add((Action)actionPathMatch.getLeft());
        }
        return actions;
    }

    public boolean hasParams(Param.In in, String ... keys) {
        for (String key : keys) {
            boolean found = false;
            for (Param param : this.params) {
                if (in != null && in != param.getIn() || !key.equalsIgnoreCase(param.getKey())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getPathParamValue(String key) {
        Path operationPath = this.getPath();
        for (Param param : this.params) {
            if (Param.In.PATH != param.getIn() || !key.equalsIgnoreCase(param.getKey())) continue;
            String value = operationPath.get(param.getIndex());
            return value;
        }
        return null;
    }

    public Op withParam(Param param) {
        for (Param p : this.getParams()) {
            if (!p.getKey().equalsIgnoreCase(param.getKey()) || p.in != Param.In.HOST && p.in != Param.In.SERVER_PATH && p.in != Param.In.PATH) continue;
            if (p.in != param.in || p.index != param.index) {
                throw ApiException.new500InternalServerError("You have a configuration error.  You can not have a path param with the same key at different locations.", new Object[0]);
            }
            if (p.getName() == null && param.getName() != null) {
                p.withName(param.getName());
            }
            if (p.getDescription() == null && param.getDescription() != null) {
                p.withDescription(param.getDescription());
            }
            param.getRegexs().forEach(r -> p.withRegex((String)r));
            if (param.isRequired()) {
                p.withRequired(true);
            }
            return this;
        }
        this.params.add(param);
        return this;
    }

    public List<Param> getParams() {
        return new ArrayList<Param>(this.params);
    }

    public void removeParam(Param param) {
        this.params.remove(param);
    }

    public List<Param> getPathParams(int pathIndex) {
        ArrayList<Param> found = new ArrayList<Param>();
        for (Param p : this.params) {
            if (p.in != Param.In.PATH || pathIndex != p.getIndex()) continue;
            found.add(p);
        }
        return found;
    }

    public Param getParam(Param.In in, String key) {
        for (Param p : this.params) {
            if (p.in != in || !key.equalsIgnoreCase(p.getKey())) continue;
            return p;
        }
        return null;
    }

    public int getPathParamCount() {
        int params = 0;
        for (int i = 0; i < this.path.size(); ++i) {
            ++params;
        }
        return params;
    }

    @Override
    public int compareTo(Op o) {
        int val;
        int n = val = o == null ? 1 : this.path.toString().compareTo(o.path.toString());
        if (val == 0) {
            int func2;
            int func1 = Op.functionAsInt(this.getFunction());
            val = func1 < (func2 = Op.functionAsInt(o.getFunction())) ? -1 : 1;
        }
        return val;
    }

    public static int functionAsInt(OpFunction func) {
        if (func == null) {
            return 0;
        }
        switch (func) {
            case GET: {
                return 1;
            }
            case FIND: {
                return 2;
            }
            case RELATED: {
                return 3;
            }
            case POST: {
                return 4;
            }
            case PUT: {
                return 5;
            }
            case PATCH: {
                return 6;
            }
            case DELETE: {
                return 7;
            }
            case BATCH_POST: {
                return 8;
            }
            case BATCH_PUT: {
                return 9;
            }
            case BATCH_PATCH: {
                return 10;
            }
            case BATCH_DELETE: {
                return 11;
            }
        }
        throw ApiException.new500InternalServerError("Unsupported OpFunction: " + func, new Object[0]);
    }

    public String getName() {
        Object defaultName;
        if (this.name != null) {
            return this.name;
        }
        Collection collection = this.getCollection();
        int pathLength = this.getPath().size();
        Object object = defaultName = this.getPath().isVar(pathLength - 1) ? this.getPath().getVarName(pathLength - 1) : this.getPath().last();
        if (this.getEndpoint().getName() != null) {
            defaultName = this.getEndpoint().getName() + Utils.capitalize((String)defaultName);
        }
        defaultName = Op.cleanNamePart((String)defaultName);
        if (((String)(defaultName = Utils.beautifyName((String)defaultName))).endsWith("*") && ((String)defaultName).length() > 1) {
            defaultName = ((String)defaultName).substring(0, ((String)defaultName).length() - 1);
        }
        String singular = Utils.capitalize((String)(collection == null ? defaultName : collection.getSingularDisplayName()));
        String plural = Utils.capitalize((String)(collection == null ? defaultName : collection.getPluralDisplayName()));
        String builtName = null;
        OpFunction function = this.getFunction();
        if (function != null) {
            switch (function) {
                case GET: {
                    builtName = "get" + singular;
                    break;
                }
                case FIND: {
                    builtName = "find" + plural;
                    break;
                }
                case RELATED: {
                    builtName = "find" + plural + "Related" + Utils.capitalize((String)Op.cleanNamePart(this.getPathParamValue("_relationship")));
                    break;
                }
                case POST: {
                    builtName = "create" + singular;
                    break;
                }
                case PUT: {
                    builtName = "update" + singular;
                    break;
                }
                case PATCH: {
                    builtName = "patch" + singular;
                    break;
                }
                case DELETE: {
                    builtName = "delete" + singular;
                    break;
                }
                case BATCH_POST: {
                    builtName = null;
                    break;
                }
                case BATCH_PUT: {
                    builtName = "batchUpdate" + plural;
                    break;
                }
                case BATCH_PATCH: {
                    builtName = "batchPatch" + plural;
                    break;
                }
                case BATCH_DELETE: {
                    builtName = "batchDelete" + plural;
                }
            }
            if (builtName != null) {
                Path p = this.getPath();
                for (int i = 0; i < p.size(); ++i) {
                    if (!p.isVar(i)) continue;
                    String key = p.getVarName(i);
                    builtName = builtName + "By" + Utils.capitalize((String)key);
                }
            }
        }
        return builtName;
    }

    static String cleanNamePart(String part) {
        if (part == null) {
            part = "Unknown";
        }
        part = part.replace("{", "");
        part = part.replace("}", "");
        part = part.replace(".", " ");
        part = part.replace("_", "");
        return part;
    }

    public Op withName(String name) {
        this.name = name;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public Op withMethod(String method) {
        this.method = method;
        return this;
    }

    public OpFunction getFunction() {
        if (this.function != null) {
            return this.function;
        }
        String method = this.getMethod().toUpperCase();
        if (this.hasParams(Param.In.PATH, "_collection", "_resource", "_relationship")) {
            switch (method) {
                case "GET": {
                    return OpFunction.RELATED;
                }
            }
            return null;
        }
        if (this.hasParams(Param.In.PATH, "_collection", "_resource")) {
            switch (method) {
                case "GET": {
                    return OpFunction.GET;
                }
                case "PUT": {
                    return OpFunction.PUT;
                }
                case "PATCH": {
                    return OpFunction.PATCH;
                }
                case "DELETE": {
                    return OpFunction.DELETE;
                }
            }
            return null;
        }
        if (this.hasParams(Param.In.PATH, "_collection")) {
            switch (method) {
                case "GET": {
                    return OpFunction.FIND;
                }
                case "POST": {
                    return OpFunction.POST;
                }
                case "PUT": {
                    return OpFunction.BATCH_PUT;
                }
                case "PATCH": {
                    return OpFunction.BATCH_PATCH;
                }
                case "DELETE": {
                    return OpFunction.BATCH_DELETE;
                }
            }
            return null;
        }
        switch (method) {
            case "GET": 
            case "POST": 
            case "PUT": 
            case "PATCH": 
            case "DELETE": {
                return OpFunction.valueOf(method);
            }
        }
        return null;
    }

    public Op withFunction(OpFunction function) {
        this.function = function;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public Op withPath(Path path) {
        if (this.path == null) {
            this.path = path.copy();
        }
        if (this.path.size() != path.size()) {
            throw ApiException.new500InternalServerError("Paths sizes are different '{}', '{}'", this.path, path);
        }
        for (int i = 0; i < path.size(); ++i) {
            boolean isVar = path.isVar(i);
            if (isVar) {
                Param param = new Param(path.getVarName(i), i);
                String regex = path.getRegex(i);
                if (regex != null) {
                    param.withRegex(regex);
                }
                this.withParam(param);
            }
            if (this.path.isVar(i) && !path.isVar(i)) {
                this.path.set(i, path.get(i));
                continue;
            }
            if (!this.path.isVar(i) || !isVar) continue;
            String currentName = this.path.getVarName(i);
            String newName = this.path.getVarName(i);
            if (!currentName.startsWith("_") || newName.startsWith("_")) continue;
            this.path.set(i, newName);
        }
        return this;
    }

    public Path getEndpointPathMatch() {
        return this.endpointPathMatch;
    }

    public Op withEndpointPathMatch(Path endpointPathMatch) {
        this.endpointPathMatch = endpointPathMatch;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Op withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Op withCollection(Collection collection) {
        this.collection = collection;
        return this;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public Op withRelationship(Relationship relationship) {
        this.relationship = relationship;
        return this;
    }

    public Api getApi() {
        return this.api;
    }

    public Op withApi(Api api) {
        this.api = api;
        return this;
    }

    public Path getDbPathMatch() {
        return this.dbPathMatch;
    }

    public Op withDbMatchPath(Path dbMatchPath) {
        this.dbPathMatch = dbMatchPath;
        return this;
    }

    public Db getDb() {
        return this.db;
    }

    public Op withDb(Db db) {
        this.db = db;
        return this;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Op withEngine(Engine engine) {
        this.engine = engine;
        return this;
    }

    public Op withDbPathMatch(Path dbPathMatch) {
        this.dbPathMatch = dbPathMatch;
        if (dbPathMatch != null) {
            int offset = 0;
            for (int i = 0; i < dbPathMatch.size() && offset + i < this.path.size(); ++i) {
                if (!dbPathMatch.isVar(i)) continue;
                Param p = new Param();
                p.withIn(Param.In.PATH);
                p.withIndex(i + offset);
                p.withKey(dbPathMatch.getVarName(i));
                String regex = dbPathMatch.getRegex(i);
                if (regex != null) {
                    p.withRegex(regex);
                }
                this.withParam(p);
            }
        }
        return this;
    }

    public Path getCollectionPathMatch() {
        return this.collectionPathMatch;
    }

    public Op withCollectionPathMatch(Path collectionPathMatch) {
        this.collectionPathMatch = collectionPathMatch;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Op withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Triple<Action, Path, Boolean>> getActionPathMatches() {
        return new ArrayList<Triple<Action, Path, Boolean>>(this.actionPathMatches);
    }

    public boolean isEpAction(Action action) {
        for (Triple<Action, Path, Boolean> match : this.actionPathMatches) {
            if (match.getLeft() != action || !((Boolean)match.getRight()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static enum OpFunction {
        GET,
        FIND,
        RELATED,
        POST,
        PUT,
        PATCH,
        DELETE,
        BATCH_POST,
        BATCH_PUT,
        BATCH_PATCH,
        BATCH_DELETE;

    }
}

