/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.Rule;
import java.util.ArrayList;
import java.util.List;

public final class Endpoint
extends Rule<Endpoint> {
    protected final List<Action> actions = new ArrayList<Action>();
    protected boolean internal = false;
    protected transient Api api = null;

    public Endpoint() {
    }

    public Endpoint(Action ... actions) {
        if (actions != null) {
            for (Action action : actions) {
                this.withAction(action);
            }
        }
    }

    public Endpoint(String ruleMatcherSpec, Action ... actions) {
        this.withIncludeOn(ruleMatcherSpec);
        if (actions != null) {
            for (Action action : actions) {
                this.withAction(action);
            }
        }
    }

    @Override
    public int compareTo(Endpoint o) {
        return this.toString().compareTo(o.toString());
    }

    public Api getApi() {
        return this.api;
    }

    public Endpoint withApi(Api api) {
        this.api = api;
        api.withEndpoint(this);
        return this;
    }

    public Endpoint withInternal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Action getAction(String name) {
        for (Action action : this.actions) {
            if (!name.equalsIgnoreCase(action.getName())) continue;
            return action;
        }
        return null;
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    public Endpoint withActions(Action ... actions) {
        for (int i = 0; actions != null && i < actions.length; ++i) {
            this.withAction(actions[i]);
        }
        return this;
    }

    public Endpoint withAction(Action action) {
        if (action == null) {
            return this;
        }
        if (this.actions.contains(action)) {
            return this;
        }
        boolean inserted = false;
        for (int i = 0; i < this.actions.size(); ++i) {
            if (action.getOrder() >= this.actions.get(i).getOrder()) continue;
            this.actions.add(i, action);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.actions.add(action);
        }
        return this;
    }
}

