/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.query;

import io.inversion.query.Builder;
import io.inversion.query.Query;
import io.inversion.rql.Term;
import java.util.ArrayList;
import java.util.List;

public class Order<T extends Order, P extends Query>
extends Builder<T, P> {
    List<Sort> sorts = new ArrayList<Sort>();

    public Order(P query) {
        super(query);
        this.withFunctions("order", "sort");
    }

    public boolean isAsc(int index) {
        List<Sort> sorts = this.getSorts();
        return sorts.size() <= index || sorts.get(index).isAsc();
    }

    public String getProperty(int index) {
        List<Sort> sorts = this.getSorts();
        return sorts.size() <= index ? null : sorts.get(index).getProperty();
    }

    public List<Sort> getSorts() {
        if (this.sorts.size() == 0) {
            for (Term term : this.getTerms()) {
                if (!term.hasToken(new String[]{"sort", "order"})) continue;
                for (Term child : term.getTerms()) {
                    String property = child.token;
                    boolean asc = true;
                    if (property.startsWith("-")) {
                        asc = false;
                        property = property.substring(1);
                    } else if (property.startsWith("+")) {
                        property = property.substring(1);
                    }
                    this.sorts.add(new Sort(property, asc));
                }
            }
        }
        return this.sorts;
    }

    public Order withSorts(List<Sort> sorts) {
        this.sorts.addAll(sorts);
        return this;
    }

    public static class Sort {
        String property;
        boolean asc;

        public Sort(String property, boolean asc) {
            this.property = property;
            this.asc = asc;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setAsc(boolean asc) {
            this.asc = asc;
        }
    }
}

