/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.impl;

import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.impl.ReflectionAcceptor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class CollectingVisitor<T>
implements Visitor {
    private final Map<Object, Object> seen = new IdentityHashMap<Object, Object>();
    private final Class<T> clazz;

    public CollectingVisitor(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void visit(Object root) {
        this.visit(null, root, null);
    }

    @Override
    public boolean visit(String name, Object value, Type fieldType) {
        if (value == null) {
            return false;
        }
        if (this.seen.put(value, value) != null) {
            return false;
        }
        if (this.clazz.isInstance(value)) {
            if (this.process(this.clazz.cast(value))) {
                ReflectionAcceptor.accept(value, this);
            }
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(item -> this.visit(null, item, null));
        } else if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> this.visit(null, v, null));
        } else {
            if (ReflectionAcceptor.isScalar(value)) {
                return false;
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    this.visit(null, Array.get(value, i), null);
                }
            } else {
                ReflectionAcceptor.accept(value, this);
            }
        }
        return false;
    }

    protected abstract boolean process(T var1);
}

