/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.MappingListBuilder;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.impl.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class SLABuilder<P>
implements BuilderBase<SLABuilder<P>> {
    public static final SLA[] DEFAULT = new SLA[]{new SLABuilder<Object>(null).build()};
    private final P parent;
    private long window = -1L;
    private double errorRatio = 1.01;
    private double invalidRatio = 1.01;
    private long meanResponseTime = Long.MAX_VALUE;
    private final Collection<SLA.PercentileLimit> limits = new ArrayList<SLA.PercentileLimit>();
    private double blockedRatio = 0.0;
    private SLA sla;

    public SLABuilder(P parent) {
        this.parent = parent;
    }

    @Override
    public void prepareBuild() {
    }

    public SLA build() {
        if (this.sla != null) {
            return this.sla;
        }
        this.sla = new SLA(this.window, this.errorRatio, this.invalidRatio, this.meanResponseTime, this.blockedRatio, this.limits);
        return this.sla;
    }

    public P endSLA() {
        return this.parent;
    }

    public SLABuilder<P> window(long window, TimeUnit timeUnit) {
        this.window = timeUnit.toMillis(window);
        return this;
    }

    public SLABuilder<P> window(String window) {
        return this.window(Util.parseToMillis(window), TimeUnit.MILLISECONDS);
    }

    public SLABuilder<P> errorRatio(double errorRatio) {
        this.errorRatio = errorRatio;
        return this;
    }

    public SLABuilder<P> invalidRatio(double invalidRatio) {
        this.invalidRatio = invalidRatio;
        return this;
    }

    public SLABuilder<P> meanResponseTime(long meanResponseTime, TimeUnit timeUnit) {
        this.meanResponseTime = timeUnit.toNanos(meanResponseTime);
        return this;
    }

    public SLABuilder<P> meanResponseTime(String meanResponseTime) {
        return this.meanResponseTime(Util.parseToNanos(meanResponseTime), TimeUnit.NANOSECONDS);
    }

    public SLABuilder<P> blockedRatio(double blockedRatio) {
        this.blockedRatio = blockedRatio;
        return this;
    }

    public LimitsBuilder limits() {
        return new LimitsBuilder();
    }

    public static class ListBuilder<P>
    implements MappingListBuilder<SLABuilder<ListBuilder<P>>> {
        private final P parent;
        private final ArrayList<SLABuilder<ListBuilder<P>>> sla = new ArrayList();

        public ListBuilder() {
            this(null);
        }

        public ListBuilder(P parent) {
            this.parent = parent;
        }

        @Override
        public SLABuilder<ListBuilder<P>> addItem() {
            SLABuilder<ListBuilder<P>> sb = new SLABuilder<ListBuilder<P>>(this);
            this.sla.add(sb);
            return sb;
        }

        public P endList() {
            return this.parent;
        }

        public SLA[] build() {
            return (SLA[])this.sla.stream().map(SLABuilder::build).toArray(SLA[]::new);
        }
    }

    public class LimitsBuilder
    extends PairBuilder.OfString {
        @Override
        public void accept(String percentileStr, String responseTime) {
            double percentile = Double.parseDouble(percentileStr);
            if (percentile < 0.0 || percentile > 1.0) {
                throw new BenchmarkDefinitionException("Percentile must be between 0.0 and 1.0");
            }
            SLABuilder.this.limits.add(new SLA.PercentileLimit(percentile, Util.parseToNanos(responseTime)));
        }

        public LimitsBuilder add(double percentile, long responseTime) {
            SLABuilder.this.limits.add(new SLA.PercentileLimit(percentile, responseTime));
            return this;
        }

        public SLABuilder<P> end() {
            return SLABuilder.this;
        }
    }
}

