/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.SessionLimitPolicy;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface Model
extends Serializable {
    public static final Logger log = LogManager.getLogger(Phase.class);

    public String description();

    default public void validate(Phase phase) {
    }

    public static class Noop
    implements Model {
        @Override
        public String description() {
            return "No-op phase";
        }
    }

    public static class Sequentially
    implements Model {
        public final int repeats;

        public Sequentially(int repeats) {
            this.repeats = repeats;
        }

        @Override
        public String description() {
            return this.repeats + " times";
        }
    }

    public static class ConstantRate
    extends OpenModel {
        public final double usersPerSec;

        public ConstantRate(double usersPerSec, boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            super(variance, maxSessions, sessionLimitPolicy);
            this.usersPerSec = usersPerSec;
        }

        @Override
        public String description() {
            return String.format("%.2f users per second", this.usersPerSec);
        }
    }

    public static class RampRate
    extends OpenModel {
        public final double initialUsersPerSec;
        public final double targetUsersPerSec;

        public RampRate(double initialUsersPerSec, double targetUsersPerSec, boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            super(variance, maxSessions, sessionLimitPolicy);
            this.initialUsersPerSec = initialUsersPerSec;
            this.targetUsersPerSec = targetUsersPerSec;
        }

        @Override
        public String description() {
            return String.format("%.2f - %.2f users per second", this.initialUsersPerSec, this.targetUsersPerSec);
        }
    }

    public static abstract class OpenModel
    implements Model {
        public final boolean variance;
        public final int maxSessions;
        public final SessionLimitPolicy sessionLimitPolicy;

        public OpenModel(boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            this.variance = variance;
            this.maxSessions = maxSessions;
            this.sessionLimitPolicy = sessionLimitPolicy;
        }

        @Override
        public void validate(Phase phase) {
            if (phase.duration < 0L) {
                throw new BenchmarkDefinitionException("Duration was not set for phase '" + phase.name + "'");
            }
        }
    }

    public static class Always
    extends ClosedModel {
        public Always(int users, int usersPerAgent, int usersPerThread) {
            super(users, usersPerAgent, usersPerThread);
        }

        @Override
        public String description() {
            return this.description("always");
        }
    }

    public static class AtOnce
    extends ClosedModel {
        public AtOnce(int users, int usersPerAgent, int usersPerThread) {
            super(users, usersPerAgent, usersPerThread);
        }

        @Override
        public void validate(Phase phase) {
            if (phase.duration > 0L) {
                log.warn("Duration ({} ms) for atOnce phase {} is ignored.", (Object)phase.duration, (Object)phase.name);
            }
        }

        @Override
        public String description() {
            return this.description("at once");
        }
    }

    public static abstract class ClosedModel
    implements Model {
        public final int users;
        public final int usersPerAgent;
        public final int usersPerThread;

        public ClosedModel(int users, int usersPerAgent, int usersPerThread) {
            this.users = users;
            this.usersPerAgent = usersPerAgent;
            this.usersPerThread = usersPerThread;
        }

        protected String description(String suffix) {
            if (this.users > 0) {
                return this.users + " users " + suffix;
            }
            if (this.usersPerAgent > 0) {
                return this.usersPerAgent + " users per agent " + suffix;
            }
            if (this.usersPerThread > 0) {
                return this.usersPerThread + " users per thread " + suffix;
            }
            return "no users will be started";
        }
    }
}

