/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

public interface BenchmarkData {
    public static final BenchmarkData EMPTY = new BenchmarkData(){

        @Override
        public InputStream readFile(String file) {
            throw new MissingFileException(file, "Cannot load file " + file + " (file set is empty).", null);
        }

        @Override
        public Map<String, byte[]> files() {
            return Collections.emptyMap();
        }
    };

    public static String sanitize(String file) {
        return file.replace(File.separatorChar, '_').replace(File.pathSeparatorChar, '_');
    }

    public InputStream readFile(String var1);

    public Map<String, byte[]> files();

    public static class MissingFileException
    extends RuntimeException {
        public final String file;

        public MissingFileException(String file) {
            this.file = file;
        }

        public MissingFileException(String file, String message, Throwable cause) {
            super(message, cause);
            this.file = file;
        }
    }
}

