/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.opentelemetry;

import io.honeycomb.opentelemetry.EnvironmentConfiguration;
import io.opentelemetry.javaagent.OpenTelemetryAgent;
import java.lang.instrument.Instrumentation;

public class HoneycombAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            HoneycombAgent.configureEnvironment();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        OpenTelemetryAgent.premain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            HoneycombAgent.configureEnvironment();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        OpenTelemetryAgent.agentmain(agentArgs, inst);
    }

    private static void configureEnvironment() throws Exception {
        String apiKey = EnvironmentConfiguration.getHoneycombApiKey();
        String apiEndpoint = EnvironmentConfiguration.getHoneycombApiEndpoint();
        String dataset = EnvironmentConfiguration.getHoneycombDataset();
        if (apiKey == null) {
            throw new Exception("WARN: Could not start Honeycomb agent: " + EnvironmentConfiguration.getErrorMessage("API key", "HONEYCOMB_API_KEY"));
        }
        if (dataset == null) {
            throw new Exception("WARN: Could not start Honeycomb agent: " + EnvironmentConfiguration.getErrorMessage("dataset", "HONEYCOMB_DATASET"));
        }
        System.setProperty("otel.exporter.otlp.headers", String.format("%s=%s,%s=%s", "X-Honeycomb-Team", apiKey, "X-Honeycomb-Dataset", dataset));
        System.setProperty("otel.exporter.otlp.endpoint", apiEndpoint);
    }
}

