/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.opentelemetry;

public class EnvironmentConfiguration {
    public static final String HONEYCOMB_API_KEY = "HONEYCOMB_API_KEY";
    public static final String HONEYCOMB_API_ENDPOINT = "HONEYCOMB_API_ENDPOINT";
    public static final String HONEYCOMB_DATASET = "HONEYCOMB_DATASET";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String SAMPLE_RATE = "SAMPLE_RATE";
    public static final String DEFAULT_HONEYCOMB_ENDPOINT = "https://api.honeycomb.io:443";
    public static final String SERVICE_NAME_FIELD = "service.name";
    public static final String HONEYCOMB_TEAM_HEADER = "X-Honeycomb-Team";
    public static final String HONEYCOMB_DATASET_HEADER = "X-Honeycomb-Dataset";

    public static String getHoneycombApiKey() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_API_KEY, null);
    }

    public static String getHoneycombApiEndpoint() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_API_ENDPOINT, DEFAULT_HONEYCOMB_ENDPOINT);
    }

    public static String getHoneycombDataset() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_DATASET, null);
    }

    public static String getServiceName() {
        return EnvironmentConfiguration.readVariable(SERVICE_NAME, null);
    }

    public static int getSampleRate() throws NumberFormatException {
        String sampleRate = EnvironmentConfiguration.readVariable(SAMPLE_RATE, "1");
        return Integer.parseInt(sampleRate);
    }

    public static String getErrorMessage(String humanKey, String key) {
        return String.format("Missing %s. Specify either %s environment variable or %s system property.", humanKey, key, EnvironmentConfiguration.getPropertyName(key));
    }

    private static String readVariable(String key, String fallback) {
        String envValue = System.getenv(key);
        String propValue = System.getProperty(EnvironmentConfiguration.getPropertyName(key));
        if (propValue != null) {
            return propValue;
        }
        if (envValue != null) {
            return envValue;
        }
        return fallback;
    }

    private static String getPropertyName(String envKey) {
        return envKey.toLowerCase().replace('_', '.');
    }
}

