/*
 * Decompiled with CFR 0.152.
 */
package io.hndrs.jwt;

import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.hndrs.jwt.ClaimSetTransformer;
import io.hndrs.jwt.Identity;
import io.hndrs.jwt.RequestTokenResolver;
import io.hndrs.jwt.UnauthorizedIdentityException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/hndrs/jwt/JwtArgumentResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "jwtProcessor", "Lcom/nimbusds/jwt/proc/JWTProcessor;", "Lcom/nimbusds/jose/proc/SecurityContext;", "claimSetTransformer", "Lio/hndrs/jwt/ClaimSetTransformer;", "requestTokenResolver", "Lio/hndrs/jwt/RequestTokenResolver;", "(Lcom/nimbusds/jwt/proc/JWTProcessor;Lio/hndrs/jwt/ClaimSetTransformer;Lio/hndrs/jwt/RequestTokenResolver;)V", "resolveArgument", "", "parameter", "Lorg/springframework/core/MethodParameter;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "resolveClaimSet", "", "", "token", "supportsParameter", "", "Companion", "jwt-auth-spring-boot-starter"})
public final class JwtArgumentResolver
implements HandlerMethodArgumentResolver {
    private final JWTProcessor<SecurityContext> jwtProcessor;
    private final ClaimSetTransformer claimSetTransformer;
    private final RequestTokenResolver requestTokenResolver;
    private static final String NO_MESSAGE = "No message";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return parameter.hasParameterAnnotation(Identity.class);
    }

    @NotNull
    public Object resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        HttpServletRequest request;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        HttpServletRequest httpServletRequest = request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String resolvedToken = this.requestTokenResolver.tokenResolver(httpServletRequest != null ? httpServletRequest.getHeader(this.requestTokenResolver.tokenHeaderName()) : null);
        Map<String, Object> resolvedClaimSet = this.resolveClaimSet(resolvedToken);
        return this.claimSetTransformer.transform(resolvedClaimSet);
    }

    private final Map<String, Object> resolveClaimSet(String token) throws Exception {
        try {
            JWT jWT = JWTParser.parse((String)token);
            Intrinsics.checkNotNullExpressionValue((Object)jWT, (String)"JWTParser.parse(token)");
            JWT jwt = jWT;
            JWTClaimsSet jWTClaimsSet = this.jwtProcessor.process(jwt, null);
            Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"jwtProcessor.process(jwt, null)");
            JWTClaimsSet claimsSet = jWTClaimsSet;
            Map map = claimsSet.getClaims();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"claimsSet.claims");
            return map;
        }
        catch (BadJWTException e) {
            StringBuilder stringBuilder = new StringBuilder().append(((Object)((Object)e)).getClass().getSimpleName()).append(" (");
            String string = e.getMessage();
            if (string == null) {
                string = NO_MESSAGE;
            }
            throw (Throwable)((Object)new UnauthorizedIdentityException(stringBuilder.append(string).append(')').toString()));
        }
        catch (BadJOSEException e) {
            StringBuilder stringBuilder = new StringBuilder().append(((Object)((Object)e)).getClass().getSimpleName()).append(" (");
            String string = e.getMessage();
            if (string == null) {
                string = NO_MESSAGE;
            }
            throw (Throwable)((Object)new UnauthorizedIdentityException(stringBuilder.append(string).append(')').toString()));
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append(e.getClass().getSimpleName()).append(" (");
            String string = e.getMessage();
            if (string == null) {
                string = NO_MESSAGE;
            }
            throw (Throwable)((Object)new UnauthorizedIdentityException(stringBuilder.append(string).append(')').toString()));
        }
    }

    public JwtArgumentResolver(@NotNull JWTProcessor<SecurityContext> jwtProcessor, @NotNull ClaimSetTransformer claimSetTransformer2, @NotNull RequestTokenResolver requestTokenResolver2) {
        Intrinsics.checkNotNullParameter(jwtProcessor, (String)"jwtProcessor");
        Intrinsics.checkNotNullParameter((Object)claimSetTransformer2, (String)"claimSetTransformer");
        Intrinsics.checkNotNullParameter((Object)requestTokenResolver2, (String)"requestTokenResolver");
        this.jwtProcessor = jwtProcessor;
        this.claimSetTransformer = claimSetTransformer2;
        this.requestTokenResolver = requestTokenResolver2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hndrs/jwt/JwtArgumentResolver$Companion;", "", "()V", "NO_MESSAGE", "", "jwt-auth-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

