/*
 * Decompiled with CFR 0.152.
 */
package io.hndrs.autoconfiguration;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.hndrs.autoconfiguration.JwtConfigurationProperties;
import io.hndrs.jwt.ClaimSetTransformer;
import io.hndrs.jwt.JwtArgumentResolver;
import io.hndrs.jwt.RequestTokenResolver;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={JwtConfigurationProperties.class})
@Configuration
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/hndrs/autoconfiguration/JwtArgumentResolverAutoconfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "properties", "Lio/hndrs/autoconfiguration/JwtConfigurationProperties;", "(Lio/hndrs/autoconfiguration/JwtConfigurationProperties;)V", "addArgumentResolvers", "", "resolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "argumentResolver", "Lio/hndrs/jwt/JwtArgumentResolver;", "claimSetTransformer", "Lio/hndrs/jwt/ClaimSetTransformer;", "jwtProcessor", "Lcom/nimbusds/jwt/proc/JWTProcessor;", "Lcom/nimbusds/jose/proc/SecurityContext;", "requestTokenResolver", "Lio/hndrs/jwt/RequestTokenResolver;", "jwt-auth-spring-boot-starter"})
public class JwtArgumentResolverAutoconfiguration
implements WebMvcConfigurer {
    private final JwtConfigurationProperties properties;

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        resolvers.add(this.argumentResolver());
    }

    @Bean
    @NotNull
    public JwtArgumentResolver argumentResolver() {
        return new JwtArgumentResolver(this.jwtProcessor(), this.claimSetTransformer(), this.requestTokenResolver());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ClaimSetTransformer claimSetTransformer() {
        return new ClaimSetTransformer(){

            @NotNull
            public Object transform(@NotNull Map<String, ? extends Object> claimSet) {
                Intrinsics.checkNotNullParameter(claimSet, (String)"claimSet");
                return ClaimSetTransformer.DefaultImpls.transform(this, claimSet);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public RequestTokenResolver requestTokenResolver() {
        return new RequestTokenResolver(){

            @NotNull
            public String tokenHeaderName() {
                return RequestTokenResolver.DefaultImpls.tokenHeaderName(this);
            }

            @NotNull
            public String tokenResolver(@Nullable String headerValue) {
                return RequestTokenResolver.DefaultImpls.tokenResolver(this, headerValue);
            }
        };
    }

    @Bean
    @NotNull
    public JWTProcessor<SecurityContext> jwtProcessor() {
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, (JWKSource)new RemoteJWKSet(new URL(this.properties.getKeyStorePath())));
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        return (JWTProcessor)jwtProcessor;
    }

    public JwtArgumentResolverAutoconfiguration(@NotNull JwtConfigurationProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
    }
}

