/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.groovyshell;

import io.hawt.example.groovyshell.GroovyShellMBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyShell
implements GroovyShellMBean {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyShell.class);
    private MBeanServer mBeanServer;
    private ObjectName objectName;
    private groovy.lang.GroovyShell shell = new groovy.lang.GroovyShell();

    public void init() {
        if (this.objectName == null) {
            try {
                this.objectName = this.getObjectName();
            }
            catch (Exception e) {
                LOG.warn("Failed to create object name: ", (Throwable)e);
                throw new RuntimeException("Failed to create object name: ", e);
            }
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                try {
                    this.mBeanServer.unregisterMBean(this.objectName);
                    this.mBeanServer.registerMBean(this, this.objectName);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register mbean: ", (Throwable)e);
                    throw new RuntimeException("Failed to register mbean: ", e);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to register mbean: ", (Throwable)e);
                throw new RuntimeException("Failed to register mbean: ", e);
            }
        }
    }

    public void destroy() {
        if (this.mBeanServer != null && this.objectName != null) {
            try {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister mbean: ", (Throwable)e);
                throw new RuntimeException("Failed to unregister mbean: ", e);
            }
        }
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=GroovyShell");
    }

    public String evaluate(String input) {
        Object out = this.shell.evaluate(input);
        if (out != null) {
            return out.toString();
        }
        return "[null]";
    }
}

