/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.model.VersionModelMaster;
import io.gs2.version.request.DeleteVersionModelMasterRequest;
import io.gs2.version.request.GetVersionModelMasterRequest;
import io.gs2.version.request.UpdateVersionModelMasterRequest;
import io.gs2.version.result.DeleteVersionModelMasterResult;
import io.gs2.version.result.GetVersionModelMasterResult;
import io.gs2.version.result.UpdateVersionModelMasterResult;

public class VersionModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final String versionName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public VersionModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String versionName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.versionName = versionName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "VersionModelMaster");
    }

    private VersionModelMaster get(GetVersionModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withVersionName(this.versionName);
        GetVersionModelMasterResult result = this.client.getVersionModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, VersionModelMasterDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public VersionModelMasterDomain update(UpdateVersionModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withVersionName(this.versionName);
        UpdateVersionModelMasterResult result = this.client.updateVersionModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, VersionModelMasterDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        VersionModelMasterDomain domain = this;
        return domain;
    }

    public VersionModelMasterDomain delete(DeleteVersionModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withVersionName(this.versionName);
        DeleteVersionModelMasterResult result = null;
        try {
            result = this.client.deleteVersionModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, VersionModelMasterDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), VersionModelMaster.class);
        VersionModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String versionName, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, versionName, childType);
    }

    public static String createCacheKey(String versionName) {
        return String.join((CharSequence)":", versionName);
    }

    public VersionModelMaster model() {
        VersionModelMaster value = this.cache.get(this.parentKey, VersionModelMasterDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetVersionModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, VersionModelMasterDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModelMaster.class);
            }
            value = this.cache.get(this.parentKey, VersionModelMasterDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModelMaster.class);
        }
        return value;
    }
}

