/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.iterator.DescribeAcceptVersionsByUserIdIterator;
import io.gs2.version.domain.model.AcceptVersionDomain;
import io.gs2.version.domain.model.CheckerDomain;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.request.CalculateSignatureRequest;
import io.gs2.version.result.CalculateSignatureResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String body;
    String signature;
    String nextPageToken;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public UserDomain calculateSignature(CalculateSignatureRequest request) {
        request.withNamespaceName(this.namespaceName);
        CalculateSignatureResult result = this.client.calculateSignature(request);
        UserDomain domain = this;
        this.body = result.getBody();
        this.signature = result.getSignature();
        return domain;
    }

    public DescribeAcceptVersionsByUserIdIterator acceptVersions() {
        return new DescribeAcceptVersionsByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public AcceptVersionDomain acceptVersion(String versionName) {
        return new AcceptVersionDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, versionName);
    }

    public CheckerDomain checker() {
        return new CheckerDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

