/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.UserDomain;
import io.gs2.version.model.AcceptVersion;
import io.gs2.version.request.AcceptByUserIdRequest;
import io.gs2.version.request.DeleteAcceptVersionByUserIdRequest;
import io.gs2.version.request.GetAcceptVersionByUserIdRequest;
import io.gs2.version.result.AcceptByUserIdResult;
import io.gs2.version.result.DeleteAcceptVersionByUserIdResult;
import io.gs2.version.result.GetAcceptVersionByUserIdResult;

public class AcceptVersionDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String versionName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public AcceptVersionDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String versionName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.versionName = versionName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "AcceptVersion");
    }

    public AcceptVersionDomain accept(AcceptByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withVersionName(this.versionName);
        AcceptByUserIdResult result = this.client.acceptByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AcceptVersionDomain domain = this;
        return domain;
    }

    private AcceptVersion get(GetAcceptVersionByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withVersionName(this.versionName);
        GetAcceptVersionByUserIdResult result = this.client.getAcceptVersionByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public AcceptVersionDomain delete(DeleteAcceptVersionByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withVersionName(this.versionName);
        DeleteAcceptVersionByUserIdResult result = null;
        try {
            result = this.client.deleteAcceptVersionByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), AcceptVersion.class);
        AcceptVersionDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String versionName, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, userId, versionName, childType);
    }

    public static String createCacheKey(String versionName) {
        return String.join((CharSequence)":", versionName);
    }

    public AcceptVersion model() {
        AcceptVersion value = this.cache.get(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
        if (value == null) {
            try {
                this.get(new GetAcceptVersionByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
            }
            value = this.cache.get(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
        }
        return value;
    }
}

