/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.iterator.DescribeStaminasIterator;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.domain.model.StaminaAccessTokenDomain;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    Long overflowValue;
    String nextPageToken;

    public Long getOverflowValue() {
        return this.overflowValue;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeStaminasIterator staminas() {
        return new DescribeStaminasIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public StaminaAccessTokenDomain stamina(String staminaName) {
        return new StaminaAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, staminaName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

