/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.RecoverValueTableMaster;
import io.gs2.stamina.request.DeleteRecoverValueTableMasterRequest;
import io.gs2.stamina.request.GetRecoverValueTableMasterRequest;
import io.gs2.stamina.request.UpdateRecoverValueTableMasterRequest;
import io.gs2.stamina.result.DeleteRecoverValueTableMasterResult;
import io.gs2.stamina.result.GetRecoverValueTableMasterResult;
import io.gs2.stamina.result.UpdateRecoverValueTableMasterResult;

public class RecoverValueTableMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String recoverValueTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRecoverValueTableName() {
        return this.recoverValueTableName;
    }

    public RecoverValueTableMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String recoverValueTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.recoverValueTableName = recoverValueTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverValueTableMaster");
    }

    private RecoverValueTableMaster get(GetRecoverValueTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverValueTableName(this.recoverValueTableName);
        GetRecoverValueTableMasterResult result = this.client.getRecoverValueTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(request.getRecoverValueTableName() != null ? request.getRecoverValueTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RecoverValueTableMasterDomain update(UpdateRecoverValueTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverValueTableName(this.recoverValueTableName);
        UpdateRecoverValueTableMasterResult result = this.client.updateRecoverValueTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(request.getRecoverValueTableName() != null ? request.getRecoverValueTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RecoverValueTableMasterDomain domain = this;
        return domain;
    }

    public RecoverValueTableMasterDomain delete(DeleteRecoverValueTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverValueTableName(this.recoverValueTableName);
        DeleteRecoverValueTableMasterResult result = null;
        try {
            result = this.client.deleteRecoverValueTableMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(request.getRecoverValueTableName() != null ? request.getRecoverValueTableName().toString() : null), RecoverValueTableMaster.class);
        RecoverValueTableMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String recoverValueTableName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, recoverValueTableName, childType);
    }

    public static String createCacheKey(String recoverValueTableName) {
        return String.join((CharSequence)":", recoverValueTableName);
    }

    public RecoverValueTableMaster model() {
        RecoverValueTableMaster value = this.cache.get(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(this.getRecoverValueTableName() != null ? this.getRecoverValueTableName().toString() : null), RecoverValueTableMaster.class);
        if (value == null) {
            try {
                this.get(new GetRecoverValueTableMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(this.getRecoverValueTableName() != null ? this.getRecoverValueTableName().toString() : null), RecoverValueTableMaster.class);
            }
            value = this.cache.get(this.parentKey, RecoverValueTableMasterDomain.createCacheKey(this.getRecoverValueTableName() != null ? this.getRecoverValueTableName().toString() : null), RecoverValueTableMaster.class);
        }
        return value;
    }
}

