/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.RecoverValueTable;

public class RecoverValueTableDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String recoverValueTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRecoverValueTableName() {
        return this.recoverValueTableName;
    }

    public RecoverValueTableDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String recoverValueTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.recoverValueTableName = recoverValueTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverValueTable");
    }

    public static String createCacheParentKey(String namespaceName, String recoverValueTableName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, recoverValueTableName, childType);
    }

    public static String createCacheKey(String recoverValueTableName) {
        return String.join((CharSequence)":", recoverValueTableName);
    }

    public RecoverValueTable model() {
        RecoverValueTable value = this.cache.get(this.parentKey, RecoverValueTableDomain.createCacheKey(this.getRecoverValueTableName() != null ? this.getRecoverValueTableName().toString() : null), RecoverValueTable.class);
        return value;
    }
}

