/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.RecoverIntervalTableMaster;
import io.gs2.stamina.request.DeleteRecoverIntervalTableMasterRequest;
import io.gs2.stamina.request.GetRecoverIntervalTableMasterRequest;
import io.gs2.stamina.request.UpdateRecoverIntervalTableMasterRequest;
import io.gs2.stamina.result.DeleteRecoverIntervalTableMasterResult;
import io.gs2.stamina.result.GetRecoverIntervalTableMasterResult;
import io.gs2.stamina.result.UpdateRecoverIntervalTableMasterResult;

public class RecoverIntervalTableMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String recoverIntervalTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRecoverIntervalTableName() {
        return this.recoverIntervalTableName;
    }

    public RecoverIntervalTableMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String recoverIntervalTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.recoverIntervalTableName = recoverIntervalTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverIntervalTableMaster");
    }

    private RecoverIntervalTableMaster get(GetRecoverIntervalTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverIntervalTableName(this.recoverIntervalTableName);
        GetRecoverIntervalTableMasterResult result = this.client.getRecoverIntervalTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(request.getRecoverIntervalTableName() != null ? request.getRecoverIntervalTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RecoverIntervalTableMasterDomain update(UpdateRecoverIntervalTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverIntervalTableName(this.recoverIntervalTableName);
        UpdateRecoverIntervalTableMasterResult result = this.client.updateRecoverIntervalTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(request.getRecoverIntervalTableName() != null ? request.getRecoverIntervalTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RecoverIntervalTableMasterDomain domain = this;
        return domain;
    }

    public RecoverIntervalTableMasterDomain delete(DeleteRecoverIntervalTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withRecoverIntervalTableName(this.recoverIntervalTableName);
        DeleteRecoverIntervalTableMasterResult result = null;
        try {
            result = this.client.deleteRecoverIntervalTableMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(request.getRecoverIntervalTableName() != null ? request.getRecoverIntervalTableName().toString() : null), RecoverIntervalTableMaster.class);
        RecoverIntervalTableMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String recoverIntervalTableName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, recoverIntervalTableName, childType);
    }

    public static String createCacheKey(String recoverIntervalTableName) {
        return String.join((CharSequence)":", recoverIntervalTableName);
    }

    public RecoverIntervalTableMaster model() {
        RecoverIntervalTableMaster value = this.cache.get(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(this.getRecoverIntervalTableName() != null ? this.getRecoverIntervalTableName().toString() : null), RecoverIntervalTableMaster.class);
        if (value == null) {
            try {
                this.get(new GetRecoverIntervalTableMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(this.getRecoverIntervalTableName() != null ? this.getRecoverIntervalTableName().toString() : null), RecoverIntervalTableMaster.class);
            }
            value = this.cache.get(this.parentKey, RecoverIntervalTableMasterDomain.createCacheKey(this.getRecoverIntervalTableName() != null ? this.getRecoverIntervalTableName().toString() : null), RecoverIntervalTableMaster.class);
        }
        return value;
    }
}

