/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.RecoverIntervalTable;

public class RecoverIntervalTableDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String recoverIntervalTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRecoverIntervalTableName() {
        return this.recoverIntervalTableName;
    }

    public RecoverIntervalTableDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String recoverIntervalTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.recoverIntervalTableName = recoverIntervalTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverIntervalTable");
    }

    public static String createCacheParentKey(String namespaceName, String recoverIntervalTableName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, recoverIntervalTableName, childType);
    }

    public static String createCacheKey(String recoverIntervalTableName) {
        return String.join((CharSequence)":", recoverIntervalTableName);
    }

    public RecoverIntervalTable model() {
        RecoverIntervalTable value = this.cache.get(this.parentKey, RecoverIntervalTableDomain.createCacheKey(this.getRecoverIntervalTableName() != null ? this.getRecoverIntervalTableName().toString() : null), RecoverIntervalTable.class);
        return value;
    }
}

