/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.CurrentStaminaMaster;
import io.gs2.stamina.request.ExportMasterRequest;
import io.gs2.stamina.request.GetCurrentStaminaMasterRequest;
import io.gs2.stamina.request.UpdateCurrentStaminaMasterFromGitHubRequest;
import io.gs2.stamina.request.UpdateCurrentStaminaMasterRequest;
import io.gs2.stamina.result.ExportMasterResult;
import io.gs2.stamina.result.GetCurrentStaminaMasterResult;
import io.gs2.stamina.result.UpdateCurrentStaminaMasterFromGitHubResult;
import io.gs2.stamina.result.UpdateCurrentStaminaMasterResult;

public class CurrentStaminaMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentStaminaMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentStaminaMaster");
    }

    public CurrentStaminaMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentStaminaMasterDomain domain = this;
        return domain;
    }

    private CurrentStaminaMaster get(GetCurrentStaminaMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentStaminaMasterResult result = this.client.getCurrentStaminaMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentStaminaMasterDomain update(UpdateCurrentStaminaMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentStaminaMasterResult result = this.client.updateCurrentStaminaMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentStaminaMasterDomain domain = this;
        return domain;
    }

    public CurrentStaminaMasterDomain updateFromGitHub(UpdateCurrentStaminaMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentStaminaMasterFromGitHubResult result = this.client.updateCurrentStaminaMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentStaminaMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentStaminaMaster model() {
        CurrentStaminaMaster value = this.cache.get(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentStaminaMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentStaminaMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentStaminaMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentStaminaMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentStaminaMaster.class);
        }
        return value;
    }
}

