/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.StaminaDomain;
import io.gs2.stamina.domain.model.UserDomain;
import io.gs2.stamina.model.Stamina;
import io.gs2.stamina.request.DescribeStaminasRequest;
import io.gs2.stamina.result.DescribeStaminasResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeStaminasIterator
implements Iterator<Stamina>,
Iterable<Stamina> {
    CacheDatabase cache;
    Gs2StaminaRestClient client;
    String namespaceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Stamina> result;
    Integer fetchSize;

    public DescribeStaminasIterator(CacheDatabase cache, Gs2StaminaRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Stamina>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Stamina");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Stamina.class)) {
            this.result = this.cache.list(parentKey, Stamina.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeStaminasResult r = this.client.describeStaminas(new DescribeStaminasRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Stamina item : this.result) {
                this.cache.put(parentKey, StaminaDomain.createCacheKey(item.getStaminaName() != null ? item.getStaminaName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Stamina.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Stamina next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Stamina ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Stamina> iterator() {
        return this;
    }
}

