/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.domain.model.StaminaModelDomain;
import io.gs2.stamina.model.StaminaModel;
import io.gs2.stamina.request.DescribeStaminaModelsRequest;
import io.gs2.stamina.result.DescribeStaminaModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeStaminaModelsIterator
implements Iterator<StaminaModel>,
Iterable<StaminaModel> {
    CacheDatabase cache;
    Gs2StaminaRestClient client;
    String namespaceName;
    boolean last;
    List<StaminaModel> result;
    Integer fetchSize;

    public DescribeStaminaModelsIterator(CacheDatabase cache, Gs2StaminaRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<StaminaModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "StaminaModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, StaminaModel.class)) {
            this.result = this.cache.list(parentKey, StaminaModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeStaminaModelsResult r = this.client.describeStaminaModels(new DescribeStaminaModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (StaminaModel item : this.result) {
                this.cache.put(parentKey, StaminaModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, StaminaModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public StaminaModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        StaminaModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<StaminaModel> iterator() {
        return this;
    }
}

