/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.domain.model.RecoverIntervalTableMasterDomain;
import io.gs2.stamina.model.RecoverIntervalTableMaster;
import io.gs2.stamina.request.DescribeRecoverIntervalTableMastersRequest;
import io.gs2.stamina.result.DescribeRecoverIntervalTableMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRecoverIntervalTableMastersIterator
implements Iterator<RecoverIntervalTableMaster>,
Iterable<RecoverIntervalTableMaster> {
    CacheDatabase cache;
    Gs2StaminaRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<RecoverIntervalTableMaster> result;
    Integer fetchSize;

    public DescribeRecoverIntervalTableMastersIterator(CacheDatabase cache, Gs2StaminaRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<RecoverIntervalTableMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverIntervalTableMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, RecoverIntervalTableMaster.class)) {
            this.result = this.cache.list(parentKey, RecoverIntervalTableMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeRecoverIntervalTableMastersResult r = this.client.describeRecoverIntervalTableMasters(new DescribeRecoverIntervalTableMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (RecoverIntervalTableMaster item : this.result) {
                this.cache.put(parentKey, RecoverIntervalTableMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, RecoverIntervalTableMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public RecoverIntervalTableMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        RecoverIntervalTableMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<RecoverIntervalTableMaster> iterator() {
        return this;
    }
}

