/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.iterator.DescribeNamespacesIterator;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.domain.model.StaminaDomain;
import io.gs2.stamina.domain.model.UserDomain;
import io.gs2.stamina.request.ConsumeStaminaByUserIdRequest;
import io.gs2.stamina.request.CreateNamespaceRequest;
import io.gs2.stamina.request.RaiseMaxValueByUserIdRequest;
import io.gs2.stamina.request.RecoverStaminaByUserIdRequest;
import io.gs2.stamina.request.SetMaxValueByUserIdRequest;
import io.gs2.stamina.request.SetRecoverIntervalByUserIdRequest;
import io.gs2.stamina.request.SetRecoverValueByUserIdRequest;
import io.gs2.stamina.result.ConsumeStaminaByUserIdResult;
import io.gs2.stamina.result.CreateNamespaceResult;
import io.gs2.stamina.result.RaiseMaxValueByUserIdResult;
import io.gs2.stamina.result.RecoverStaminaByUserIdResult;
import io.gs2.stamina.result.SetMaxValueByUserIdResult;
import io.gs2.stamina.result.SetRecoverIntervalByUserIdResult;
import io.gs2.stamina.result.SetRecoverValueByUserIdResult;

public class Gs2Stamina {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String parentKey;

    public Gs2Stamina(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.parentKey = "stamina";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "stamina:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "RecoverStaminaByUserId": {
                    RecoverStaminaByUserIdRequest requestModel = RecoverStaminaByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    RecoverStaminaByUserIdResult resultModel = RecoverStaminaByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "RaiseMaxValueByUserId": {
                    RaiseMaxValueByUserIdRequest requestModel = RaiseMaxValueByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    RaiseMaxValueByUserIdResult resultModel = RaiseMaxValueByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "SetMaxValueByUserId": {
                    SetMaxValueByUserIdRequest requestModel = SetMaxValueByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    SetMaxValueByUserIdResult resultModel = SetMaxValueByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "SetRecoverIntervalByUserId": {
                    SetRecoverIntervalByUserIdRequest requestModel = SetRecoverIntervalByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    SetRecoverIntervalByUserIdResult resultModel = SetRecoverIntervalByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "SetRecoverValueByUserId": {
                    SetRecoverValueByUserIdRequest requestModel = SetRecoverValueByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    SetRecoverValueByUserIdResult resultModel = SetRecoverValueByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "ConsumeStaminaByUserId": {
                    ConsumeStaminaByUserIdRequest requestModel = ConsumeStaminaByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    ConsumeStaminaByUserIdResult resultModel = ConsumeStaminaByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "recover_stamina_by_user_id": {
                    RecoverStaminaByUserIdRequest requestModel = RecoverStaminaByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    RecoverStaminaByUserIdResult resultModel = RecoverStaminaByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "raise_max_value_by_user_id": {
                    RaiseMaxValueByUserIdRequest requestModel = RaiseMaxValueByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    RaiseMaxValueByUserIdResult resultModel = RaiseMaxValueByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "set_max_value_by_user_id": {
                    SetMaxValueByUserIdRequest requestModel = SetMaxValueByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    SetMaxValueByUserIdResult resultModel = SetMaxValueByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "set_recover_interval_by_user_id": {
                    SetRecoverIntervalByUserIdRequest requestModel = SetRecoverIntervalByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    SetRecoverIntervalByUserIdResult resultModel = SetRecoverIntervalByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "set_recover_value_by_user_id": {
                    SetRecoverValueByUserIdRequest requestModel = SetRecoverValueByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    SetRecoverValueByUserIdResult resultModel = SetRecoverValueByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Stamina");
                    String key = StaminaDomain.createCacheKey(resultModel.getItem().getStaminaName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

