/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.model.ShowcaseMaster;
import io.gs2.showcase.request.DeleteShowcaseMasterRequest;
import io.gs2.showcase.request.GetShowcaseMasterRequest;
import io.gs2.showcase.request.UpdateShowcaseMasterRequest;
import io.gs2.showcase.result.DeleteShowcaseMasterResult;
import io.gs2.showcase.result.GetShowcaseMasterResult;
import io.gs2.showcase.result.UpdateShowcaseMasterResult;

public class ShowcaseMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String showcaseName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getShowcaseName() {
        return this.showcaseName;
    }

    public ShowcaseMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String showcaseName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.showcaseName = showcaseName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ShowcaseMaster");
    }

    private ShowcaseMaster get(GetShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withShowcaseName(this.showcaseName);
        GetShowcaseMasterResult result = this.client.getShowcaseMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ShowcaseMasterDomain.createCacheKey(request.getShowcaseName() != null ? request.getShowcaseName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ShowcaseMasterDomain update(UpdateShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withShowcaseName(this.showcaseName);
        UpdateShowcaseMasterResult result = this.client.updateShowcaseMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ShowcaseMasterDomain.createCacheKey(request.getShowcaseName() != null ? request.getShowcaseName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ShowcaseMasterDomain domain = this;
        return domain;
    }

    public ShowcaseMasterDomain delete(DeleteShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withShowcaseName(this.showcaseName);
        DeleteShowcaseMasterResult result = null;
        try {
            result = this.client.deleteShowcaseMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ShowcaseMasterDomain.createCacheKey(request.getShowcaseName() != null ? request.getShowcaseName().toString() : null), ShowcaseMaster.class);
        ShowcaseMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String showcaseName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, showcaseName, childType);
    }

    public static String createCacheKey(String showcaseName) {
        return String.join((CharSequence)":", showcaseName);
    }

    public ShowcaseMaster model() {
        ShowcaseMaster value = this.cache.get(this.parentKey, ShowcaseMasterDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), ShowcaseMaster.class);
        if (value == null) {
            try {
                this.get(new GetShowcaseMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ShowcaseMasterDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), ShowcaseMaster.class);
            }
            value = this.cache.get(this.parentKey, ShowcaseMasterDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), ShowcaseMaster.class);
        }
        return value;
    }
}

