/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.domain.model.SalesItemDomain;
import io.gs2.showcase.domain.model.UserDomain;
import io.gs2.showcase.model.Showcase;
import io.gs2.showcase.request.BuyByUserIdRequest;
import io.gs2.showcase.request.GetShowcaseByUserIdRequest;
import io.gs2.showcase.result.BuyByUserIdResult;
import io.gs2.showcase.result.GetShowcaseByUserIdResult;

public class ShowcaseDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String showcaseName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getShowcaseName() {
        return this.showcaseName;
    }

    public ShowcaseDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String showcaseName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.showcaseName = showcaseName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Showcase");
    }

    private Showcase get(GetShowcaseByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withShowcaseName(this.showcaseName);
        GetShowcaseByUserIdResult result = this.client.getShowcaseByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ShowcaseDomain.createCacheKey(request.getShowcaseName() != null ? request.getShowcaseName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain buy(BuyByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withShowcaseName(this.showcaseName);
        BuyByUserIdResult result = this.client.buyByUserId(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItem");
        if (result.getItem() != null) {
            this.cache.put(parentKey, SalesItemDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String showcaseName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, userId, showcaseName, childType);
    }

    public static String createCacheKey(String showcaseName) {
        return String.join((CharSequence)":", showcaseName);
    }

    public Showcase model() {
        Showcase value = this.cache.get(this.parentKey, ShowcaseDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), Showcase.class);
        if (value == null) {
            try {
                this.get(new GetShowcaseByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ShowcaseDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), Showcase.class);
            }
            value = this.cache.get(this.parentKey, ShowcaseDomain.createCacheKey(this.getShowcaseName() != null ? this.getShowcaseName().toString() : null), Showcase.class);
        }
        return value;
    }
}

