/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.model.SalesItemMaster;
import io.gs2.showcase.request.DeleteSalesItemMasterRequest;
import io.gs2.showcase.request.GetSalesItemMasterRequest;
import io.gs2.showcase.request.UpdateSalesItemMasterRequest;
import io.gs2.showcase.result.DeleteSalesItemMasterResult;
import io.gs2.showcase.result.GetSalesItemMasterResult;
import io.gs2.showcase.result.UpdateSalesItemMasterResult;

public class SalesItemMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String salesItemName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSalesItemName() {
        return this.salesItemName;
    }

    public SalesItemMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String salesItemName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.salesItemName = salesItemName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemMaster");
    }

    private SalesItemMaster get(GetSalesItemMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemName(this.salesItemName);
        GetSalesItemMasterResult result = this.client.getSalesItemMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SalesItemMasterDomain.createCacheKey(request.getSalesItemName() != null ? request.getSalesItemName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SalesItemMasterDomain update(UpdateSalesItemMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemName(this.salesItemName);
        UpdateSalesItemMasterResult result = this.client.updateSalesItemMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SalesItemMasterDomain.createCacheKey(request.getSalesItemName() != null ? request.getSalesItemName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SalesItemMasterDomain domain = this;
        return domain;
    }

    public SalesItemMasterDomain delete(DeleteSalesItemMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemName(this.salesItemName);
        DeleteSalesItemMasterResult result = null;
        try {
            result = this.client.deleteSalesItemMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, SalesItemMasterDomain.createCacheKey(request.getSalesItemName() != null ? request.getSalesItemName().toString() : null), SalesItemMaster.class);
        SalesItemMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String salesItemName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, salesItemName, childType);
    }

    public static String createCacheKey(String salesItemName) {
        return String.join((CharSequence)":", salesItemName);
    }

    public SalesItemMaster model() {
        SalesItemMaster value = this.cache.get(this.parentKey, SalesItemMasterDomain.createCacheKey(this.getSalesItemName() != null ? this.getSalesItemName().toString() : null), SalesItemMaster.class);
        if (value == null) {
            try {
                this.get(new GetSalesItemMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SalesItemMasterDomain.createCacheKey(this.getSalesItemName() != null ? this.getSalesItemName().toString() : null), SalesItemMaster.class);
            }
            value = this.cache.get(this.parentKey, SalesItemMasterDomain.createCacheKey(this.getSalesItemName() != null ? this.getSalesItemName().toString() : null), SalesItemMaster.class);
        }
        return value;
    }
}

