/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.domain.model.SalesItemMasterDomain;
import io.gs2.showcase.model.SalesItemMaster;
import io.gs2.showcase.request.DescribeSalesItemMastersRequest;
import io.gs2.showcase.result.DescribeSalesItemMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSalesItemMastersIterator
implements Iterator<SalesItemMaster>,
Iterable<SalesItemMaster> {
    CacheDatabase cache;
    Gs2ShowcaseRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<SalesItemMaster> result;
    Integer fetchSize;

    public DescribeSalesItemMastersIterator(CacheDatabase cache, Gs2ShowcaseRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<SalesItemMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, SalesItemMaster.class)) {
            this.result = this.cache.list(parentKey, SalesItemMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeSalesItemMastersResult r = this.client.describeSalesItemMasters(new DescribeSalesItemMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (SalesItemMaster item : this.result) {
                this.cache.put(parentKey, SalesItemMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, SalesItemMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public SalesItemMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        SalesItemMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<SalesItemMaster> iterator() {
        return this;
    }
}

