/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.domain.model.SalesItemGroupMasterDomain;
import io.gs2.showcase.model.SalesItemGroupMaster;
import io.gs2.showcase.request.DescribeSalesItemGroupMastersRequest;
import io.gs2.showcase.result.DescribeSalesItemGroupMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSalesItemGroupMastersIterator
implements Iterator<SalesItemGroupMaster>,
Iterable<SalesItemGroupMaster> {
    CacheDatabase cache;
    Gs2ShowcaseRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<SalesItemGroupMaster> result;
    Integer fetchSize;

    public DescribeSalesItemGroupMastersIterator(CacheDatabase cache, Gs2ShowcaseRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<SalesItemGroupMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemGroupMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, SalesItemGroupMaster.class)) {
            this.result = this.cache.list(parentKey, SalesItemGroupMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeSalesItemGroupMastersResult r = this.client.describeSalesItemGroupMasters(new DescribeSalesItemGroupMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (SalesItemGroupMaster item : this.result) {
                this.cache.put(parentKey, SalesItemGroupMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, SalesItemGroupMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public SalesItemGroupMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        SalesItemGroupMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<SalesItemGroupMaster> iterator() {
        return this;
    }
}

