/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.script.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.script.Gs2ScriptRestClient;
import io.gs2.script.domain.model.NamespaceDomain;
import io.gs2.script.model.Script;
import io.gs2.script.request.DeleteScriptRequest;
import io.gs2.script.request.GetScriptRequest;
import io.gs2.script.request.UpdateScriptFromGitHubRequest;
import io.gs2.script.request.UpdateScriptRequest;
import io.gs2.script.result.DeleteScriptResult;
import io.gs2.script.result.GetScriptResult;
import io.gs2.script.result.UpdateScriptFromGitHubResult;
import io.gs2.script.result.UpdateScriptResult;
import java.util.List;

public class ScriptDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScriptRestClient client;
    private final String namespaceName;
    private final String scriptName;
    private final String parentKey;
    Integer code;
    String result;
    Integer executeTime;
    Integer charged;
    List<String> output;

    public Integer getCode() {
        return this.code;
    }

    public String getResult() {
        return this.result;
    }

    public Integer getExecuteTime() {
        return this.executeTime;
    }

    public Integer getCharged() {
        return this.charged;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public ScriptDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String scriptName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScriptRestClient(session);
        this.namespaceName = namespaceName;
        this.scriptName = scriptName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Script");
    }

    private Script get(GetScriptRequest request) {
        request.withNamespaceName(this.namespaceName).withScriptName(this.scriptName);
        GetScriptResult result = this.client.getScript(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ScriptDomain.createCacheKey(request.getScriptName() != null ? request.getScriptName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ScriptDomain update(UpdateScriptRequest request) {
        request.withNamespaceName(this.namespaceName).withScriptName(this.scriptName);
        UpdateScriptResult result = this.client.updateScript(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ScriptDomain.createCacheKey(request.getScriptName() != null ? request.getScriptName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScriptDomain domain = this;
        return domain;
    }

    public ScriptDomain updateFromGitHub(UpdateScriptFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName).withScriptName(this.scriptName);
        UpdateScriptFromGitHubResult result = this.client.updateScriptFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ScriptDomain.createCacheKey(request.getScriptName() != null ? request.getScriptName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScriptDomain domain = this;
        return domain;
    }

    public ScriptDomain delete(DeleteScriptRequest request) {
        request.withNamespaceName(this.namespaceName).withScriptName(this.scriptName);
        DeleteScriptResult result = null;
        try {
            result = this.client.deleteScript(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ScriptDomain.createCacheKey(request.getScriptName() != null ? request.getScriptName().toString() : null), Script.class);
        ScriptDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String scriptName, String childType) {
        return String.join((CharSequence)":", "script", namespaceName, scriptName, childType);
    }

    public static String createCacheKey(String scriptName) {
        return String.join((CharSequence)":", scriptName);
    }

    public Script model() {
        Script value = this.cache.get(this.parentKey, ScriptDomain.createCacheKey(this.getScriptName() != null ? this.getScriptName().toString() : null), Script.class);
        if (value == null) {
            try {
                this.get(new GetScriptRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ScriptDomain.createCacheKey(this.getScriptName() != null ? this.getScriptName().toString() : null), Script.class);
            }
            value = this.cache.get(this.parentKey, ScriptDomain.createCacheKey(this.getScriptName() != null ? this.getScriptName().toString() : null), Script.class);
        }
        return value;
    }
}

