/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.script.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.script.Gs2ScriptRestClient;
import io.gs2.script.domain.model.NamespaceDomain;
import io.gs2.script.domain.model.ScriptDomain;
import io.gs2.script.model.Script;
import io.gs2.script.request.DescribeScriptsRequest;
import io.gs2.script.result.DescribeScriptsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeScriptsIterator
implements Iterator<Script>,
Iterable<Script> {
    CacheDatabase cache;
    Gs2ScriptRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<Script> result;
    Integer fetchSize;

    public DescribeScriptsIterator(CacheDatabase cache, Gs2ScriptRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Script>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Script");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Script.class)) {
            this.result = this.cache.list(parentKey, Script.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeScriptsResult r = this.client.describeScripts(new DescribeScriptsRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Script item : this.result) {
                this.cache.put(parentKey, ScriptDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Script.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Script next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Script ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Script> iterator() {
        return this;
    }
}

