/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.UserDomain;
import io.gs2.schedule.model.Event;
import io.gs2.schedule.request.GetEventByUserIdRequest;
import io.gs2.schedule.result.GetEventByUserIdResult;

public class EventDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScheduleRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String eventName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public EventDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String eventName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScheduleRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.eventName = eventName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Event");
    }

    private Event get(GetEventByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withEventName(this.eventName);
        GetEventByUserIdResult result = this.client.getEventByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EventDomain.createCacheKey(request.getEventName() != null ? request.getEventName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String eventName, String childType) {
        return String.join((CharSequence)":", "schedule", namespaceName, userId, eventName, childType);
    }

    public static String createCacheKey(String eventName) {
        return String.join((CharSequence)":", eventName);
    }

    public Event model() {
        Event value = this.cache.get(this.parentKey, EventDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), Event.class);
        if (value == null) {
            try {
                this.get(new GetEventByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EventDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), Event.class);
            }
            value = this.cache.get(this.parentKey, EventDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), Event.class);
        }
        return value;
    }
}

