/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.NamespaceDomain;
import io.gs2.schedule.model.CurrentEventMaster;
import io.gs2.schedule.request.ExportMasterRequest;
import io.gs2.schedule.request.GetCurrentEventMasterRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterFromGitHubRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterRequest;
import io.gs2.schedule.result.ExportMasterResult;
import io.gs2.schedule.result.GetCurrentEventMasterResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterFromGitHubResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterResult;

public class CurrentEventMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScheduleRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentEventMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScheduleRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentEventMaster");
    }

    public CurrentEventMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEventMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEventMasterDomain domain = this;
        return domain;
    }

    private CurrentEventMaster get(GetCurrentEventMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentEventMasterResult result = this.client.getCurrentEventMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEventMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentEventMasterDomain update(UpdateCurrentEventMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentEventMasterResult result = this.client.updateCurrentEventMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEventMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEventMasterDomain domain = this;
        return domain;
    }

    public CurrentEventMasterDomain updateFromGitHub(UpdateCurrentEventMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentEventMasterFromGitHubResult result = this.client.updateCurrentEventMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentEventMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentEventMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "schedule", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentEventMaster model() {
        CurrentEventMaster value = this.cache.get(this.parentKey, CurrentEventMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEventMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentEventMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentEventMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEventMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentEventMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentEventMaster.class);
        }
        return value;
    }
}

