/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.schedule.request.CreateEventMasterRequest;
import io.gs2.schedule.request.CreateNamespaceRequest;
import io.gs2.schedule.request.DeleteEventMasterRequest;
import io.gs2.schedule.request.DeleteNamespaceRequest;
import io.gs2.schedule.request.DeleteTriggerByUserIdRequest;
import io.gs2.schedule.request.DeleteTriggerRequest;
import io.gs2.schedule.request.DescribeEventMastersRequest;
import io.gs2.schedule.request.DescribeEventsByUserIdRequest;
import io.gs2.schedule.request.DescribeEventsRequest;
import io.gs2.schedule.request.DescribeNamespacesRequest;
import io.gs2.schedule.request.DescribeRawEventsRequest;
import io.gs2.schedule.request.DescribeTriggersByUserIdRequest;
import io.gs2.schedule.request.DescribeTriggersRequest;
import io.gs2.schedule.request.ExportMasterRequest;
import io.gs2.schedule.request.GetCurrentEventMasterRequest;
import io.gs2.schedule.request.GetEventByUserIdRequest;
import io.gs2.schedule.request.GetEventMasterRequest;
import io.gs2.schedule.request.GetEventRequest;
import io.gs2.schedule.request.GetNamespaceRequest;
import io.gs2.schedule.request.GetNamespaceStatusRequest;
import io.gs2.schedule.request.GetRawEventRequest;
import io.gs2.schedule.request.GetTriggerByUserIdRequest;
import io.gs2.schedule.request.GetTriggerRequest;
import io.gs2.schedule.request.TriggerByUserIdRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterFromGitHubRequest;
import io.gs2.schedule.request.UpdateCurrentEventMasterRequest;
import io.gs2.schedule.request.UpdateEventMasterRequest;
import io.gs2.schedule.request.UpdateNamespaceRequest;
import io.gs2.schedule.result.CreateEventMasterResult;
import io.gs2.schedule.result.CreateNamespaceResult;
import io.gs2.schedule.result.DeleteEventMasterResult;
import io.gs2.schedule.result.DeleteNamespaceResult;
import io.gs2.schedule.result.DeleteTriggerByUserIdResult;
import io.gs2.schedule.result.DeleteTriggerResult;
import io.gs2.schedule.result.DescribeEventMastersResult;
import io.gs2.schedule.result.DescribeEventsByUserIdResult;
import io.gs2.schedule.result.DescribeEventsResult;
import io.gs2.schedule.result.DescribeNamespacesResult;
import io.gs2.schedule.result.DescribeRawEventsResult;
import io.gs2.schedule.result.DescribeTriggersByUserIdResult;
import io.gs2.schedule.result.DescribeTriggersResult;
import io.gs2.schedule.result.ExportMasterResult;
import io.gs2.schedule.result.GetCurrentEventMasterResult;
import io.gs2.schedule.result.GetEventByUserIdResult;
import io.gs2.schedule.result.GetEventMasterResult;
import io.gs2.schedule.result.GetEventResult;
import io.gs2.schedule.result.GetNamespaceResult;
import io.gs2.schedule.result.GetNamespaceStatusResult;
import io.gs2.schedule.result.GetRawEventResult;
import io.gs2.schedule.result.GetTriggerByUserIdResult;
import io.gs2.schedule.result.GetTriggerResult;
import io.gs2.schedule.result.TriggerByUserIdResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterFromGitHubResult;
import io.gs2.schedule.result.UpdateCurrentEventMasterResult;
import io.gs2.schedule.result.UpdateEventMasterResult;
import io.gs2.schedule.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2ScheduleRestClient
extends AbstractGs2Client<Gs2ScheduleRestClient> {
    public Gs2ScheduleRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeEventMastersAsync(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> callback) {
        DescribeEventMastersTask task = new DescribeEventMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventMastersResult describeEventMasters(DescribeEventMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventMastersResult)resultAsyncResult[0].getResult();
    }

    public void createEventMasterAsync(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> callback) {
        CreateEventMasterTask task = new CreateEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateEventMasterResult createEventMaster(CreateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void getEventMasterAsync(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> callback) {
        GetEventMasterTask task = new GetEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetEventMasterResult getEventMaster(GetEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateEventMasterAsync(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> callback) {
        UpdateEventMasterTask task = new UpdateEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateEventMasterResult updateEventMaster(UpdateEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteEventMasterAsync(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> callback) {
        DeleteEventMasterTask task = new DeleteEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteEventMasterResult deleteEventMaster(DeleteEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersAsync(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> callback) {
        DescribeTriggersTask task = new DescribeTriggersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTriggersResult describeTriggers(DescribeTriggersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersResult)resultAsyncResult[0].getResult();
    }

    public void describeTriggersByUserIdAsync(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> callback) {
        DescribeTriggersByUserIdTask task = new DescribeTriggersByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTriggersByUserIdResult describeTriggersByUserId(DescribeTriggersByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTriggersByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTriggersByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerAsync(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> callback) {
        GetTriggerTask task = new GetTriggerTask(request, callback);
        this.session.execute(task);
    }

    public GetTriggerResult getTrigger(GetTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerResult)resultAsyncResult[0].getResult();
    }

    public void getTriggerByUserIdAsync(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> callback) {
        GetTriggerByUserIdTask task = new GetTriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetTriggerByUserIdResult getTriggerByUserId(GetTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTriggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void triggerByUserIdAsync(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> callback) {
        TriggerByUserIdTask task = new TriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public TriggerByUserIdResult triggerByUserId(TriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.triggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (TriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerAsync(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> callback) {
        DeleteTriggerTask task = new DeleteTriggerTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTriggerResult deleteTrigger(DeleteTriggerRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerResult)resultAsyncResult[0].getResult();
    }

    public void deleteTriggerByUserIdAsync(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> callback) {
        DeleteTriggerByUserIdTask task = new DeleteTriggerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTriggerByUserIdResult deleteTriggerByUserId(DeleteTriggerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTriggerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTriggerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsAsync(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> callback) {
        DescribeEventsTask task = new DescribeEventsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsByUserIdAsync(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> callback) {
        DescribeEventsByUserIdTask task = new DescribeEventsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventsByUserIdResult describeEventsByUserId(DescribeEventsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRawEventsAsync(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> callback) {
        DescribeRawEventsTask task = new DescribeRawEventsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRawEventsResult describeRawEvents(DescribeRawEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRawEventsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRawEventsResult)resultAsyncResult[0].getResult();
    }

    public void getEventAsync(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> callback) {
        GetEventTask task = new GetEventTask(request, callback);
        this.session.execute(task);
    }

    public GetEventResult getEvent(GetEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventResult)resultAsyncResult[0].getResult();
    }

    public void getEventByUserIdAsync(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> callback) {
        GetEventByUserIdTask task = new GetEventByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetEventByUserIdResult getEventByUserId(GetEventByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getRawEventAsync(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> callback) {
        GetRawEventTask task = new GetRawEventTask(request, callback);
        this.session.execute(task);
    }

    public GetRawEventResult getRawEvent(GetRawEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRawEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRawEventResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentEventMasterAsync(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> callback) {
        GetCurrentEventMasterTask task = new GetCurrentEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentEventMasterResult getCurrentEventMaster(GetCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEventMasterAsync(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> callback) {
        UpdateCurrentEventMasterTask task = new UpdateCurrentEventMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEventMasterResult updateCurrentEventMaster(UpdateCurrentEventMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEventMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEventMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEventMasterFromGitHubAsync(UpdateCurrentEventMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterFromGitHubResult>> callback) {
        UpdateCurrentEventMasterFromGitHubTask task = new UpdateCurrentEventMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEventMasterFromGitHubResult updateCurrentEventMasterFromGitHub(UpdateCurrentEventMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEventMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEventMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class UpdateCurrentEventMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentEventMasterFromGitHubResult> {
        private UpdateCurrentEventMasterFromGitHubRequest request;

        public UpdateCurrentEventMasterFromGitHubTask(UpdateCurrentEventMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEventMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentEventMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentEventMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentEventMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentEventMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentEventMasterTask
    extends Gs2RestSessionTask<UpdateCurrentEventMasterResult> {
        private UpdateCurrentEventMasterRequest request;

        public UpdateCurrentEventMasterTask(UpdateCurrentEventMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEventMasterResult parse(JsonNode data) {
            return UpdateCurrentEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentEventMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentEventMasterTask
    extends Gs2RestSessionTask<GetCurrentEventMasterResult> {
        private GetCurrentEventMasterRequest request;

        public GetCurrentEventMasterTask(GetCurrentEventMasterRequest request, AsyncAction<AsyncResult<GetCurrentEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentEventMasterResult parse(JsonNode data) {
            return GetCurrentEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRawEventTask
    extends Gs2RestSessionTask<GetRawEventResult> {
        private GetRawEventRequest request;

        public GetRawEventTask(GetRawEventRequest request, AsyncAction<AsyncResult<GetRawEventResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRawEventResult parse(JsonNode data) {
            return GetRawEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventByUserIdTask
    extends Gs2RestSessionTask<GetEventByUserIdResult> {
        private GetEventByUserIdRequest request;

        public GetEventByUserIdTask(GetEventByUserIdRequest request, AsyncAction<AsyncResult<GetEventByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventByUserIdResult parse(JsonNode data) {
            return GetEventByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventTask
    extends Gs2RestSessionTask<GetEventResult> {
        private GetEventRequest request;

        public GetEventTask(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventResult parse(JsonNode data) {
            return GetEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeRawEventsTask
    extends Gs2RestSessionTask<DescribeRawEventsResult> {
        private DescribeRawEventsRequest request;

        public DescribeRawEventsTask(DescribeRawEventsRequest request, AsyncAction<AsyncResult<DescribeRawEventsResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRawEventsResult parse(JsonNode data) {
            return DescribeRawEventsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsByUserIdTask
    extends Gs2RestSessionTask<DescribeEventsByUserIdResult> {
        private DescribeEventsByUserIdRequest request;

        public DescribeEventsByUserIdTask(DescribeEventsByUserIdRequest request, AsyncAction<AsyncResult<DescribeEventsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventsByUserIdResult parse(JsonNode data) {
            return DescribeEventsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsTask
    extends Gs2RestSessionTask<DescribeEventsResult> {
        private DescribeEventsRequest request;

        public DescribeEventsTask(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventsResult parse(JsonNode data) {
            return DescribeEventsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerByUserIdTask
    extends Gs2RestSessionTask<DeleteTriggerByUserIdResult> {
        private DeleteTriggerByUserIdRequest request;

        public DeleteTriggerByUserIdTask(DeleteTriggerByUserIdRequest request, AsyncAction<AsyncResult<DeleteTriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTriggerByUserIdResult parse(JsonNode data) {
            return DeleteTriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteTriggerTask
    extends Gs2RestSessionTask<DeleteTriggerResult> {
        private DeleteTriggerRequest request;

        public DeleteTriggerTask(DeleteTriggerRequest request, AsyncAction<AsyncResult<DeleteTriggerResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTriggerResult parse(JsonNode data) {
            return DeleteTriggerResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class TriggerByUserIdTask
    extends Gs2RestSessionTask<TriggerByUserIdResult> {
        private TriggerByUserIdRequest request;

        public TriggerByUserIdTask(TriggerByUserIdRequest request, AsyncAction<AsyncResult<TriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public TriggerByUserIdResult parse(JsonNode data) {
            return TriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("triggerStrategy", TriggerByUserIdTask.this.request.getTriggerStrategy());
                    this.put("ttl", TriggerByUserIdTask.this.request.getTtl());
                    this.put("contextStack", TriggerByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerByUserIdTask
    extends Gs2RestSessionTask<GetTriggerByUserIdResult> {
        private GetTriggerByUserIdRequest request;

        public GetTriggerByUserIdTask(GetTriggerByUserIdRequest request, AsyncAction<AsyncResult<GetTriggerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTriggerByUserIdResult parse(JsonNode data) {
            return GetTriggerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetTriggerTask
    extends Gs2RestSessionTask<GetTriggerResult> {
        private GetTriggerRequest request;

        public GetTriggerTask(GetTriggerRequest request, AsyncAction<AsyncResult<GetTriggerResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTriggerResult parse(JsonNode data) {
            return GetTriggerResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger/{triggerName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{triggerName}", this.request.getTriggerName() == null || this.request.getTriggerName().length() == 0 ? "null" : String.valueOf(this.request.getTriggerName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersByUserIdTask
    extends Gs2RestSessionTask<DescribeTriggersByUserIdResult> {
        private DescribeTriggersByUserIdRequest request;

        public DescribeTriggersByUserIdTask(DescribeTriggersByUserIdRequest request, AsyncAction<AsyncResult<DescribeTriggersByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTriggersByUserIdResult parse(JsonNode data) {
            return DescribeTriggersByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeTriggersTask
    extends Gs2RestSessionTask<DescribeTriggersResult> {
        private DescribeTriggersRequest request;

        public DescribeTriggersTask(DescribeTriggersRequest request, AsyncAction<AsyncResult<DescribeTriggersResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTriggersResult parse(JsonNode data) {
            return DescribeTriggersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/trigger";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteEventMasterTask
    extends Gs2RestSessionTask<DeleteEventMasterResult> {
        private DeleteEventMasterRequest request;

        public DeleteEventMasterTask(DeleteEventMasterRequest request, AsyncAction<AsyncResult<DeleteEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteEventMasterResult parse(JsonNode data) {
            return DeleteEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateEventMasterTask
    extends Gs2RestSessionTask<UpdateEventMasterResult> {
        private UpdateEventMasterRequest request;

        public UpdateEventMasterTask(UpdateEventMasterRequest request, AsyncAction<AsyncResult<UpdateEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateEventMasterResult parse(JsonNode data) {
            return UpdateEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateEventMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateEventMasterTask.this.request.getMetadata());
                    this.put("scheduleType", UpdateEventMasterTask.this.request.getScheduleType());
                    this.put("absoluteBegin", UpdateEventMasterTask.this.request.getAbsoluteBegin());
                    this.put("absoluteEnd", UpdateEventMasterTask.this.request.getAbsoluteEnd());
                    this.put("repeatType", UpdateEventMasterTask.this.request.getRepeatType());
                    this.put("repeatBeginDayOfMonth", UpdateEventMasterTask.this.request.getRepeatBeginDayOfMonth());
                    this.put("repeatEndDayOfMonth", UpdateEventMasterTask.this.request.getRepeatEndDayOfMonth());
                    this.put("repeatBeginDayOfWeek", UpdateEventMasterTask.this.request.getRepeatBeginDayOfWeek());
                    this.put("repeatEndDayOfWeek", UpdateEventMasterTask.this.request.getRepeatEndDayOfWeek());
                    this.put("repeatBeginHour", UpdateEventMasterTask.this.request.getRepeatBeginHour());
                    this.put("repeatEndHour", UpdateEventMasterTask.this.request.getRepeatEndHour());
                    this.put("relativeTriggerName", UpdateEventMasterTask.this.request.getRelativeTriggerName());
                    this.put("relativeDuration", UpdateEventMasterTask.this.request.getRelativeDuration());
                    this.put("contextStack", UpdateEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventMasterTask
    extends Gs2RestSessionTask<GetEventMasterResult> {
        private GetEventMasterRequest request;

        public GetEventMasterTask(GetEventMasterRequest request, AsyncAction<AsyncResult<GetEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventMasterResult parse(JsonNode data) {
            return GetEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event/{eventName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateEventMasterTask
    extends Gs2RestSessionTask<CreateEventMasterResult> {
        private CreateEventMasterRequest request;

        public CreateEventMasterTask(CreateEventMasterRequest request, AsyncAction<AsyncResult<CreateEventMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateEventMasterResult parse(JsonNode data) {
            return CreateEventMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateEventMasterTask.this.request.getName());
                    this.put("description", CreateEventMasterTask.this.request.getDescription());
                    this.put("metadata", CreateEventMasterTask.this.request.getMetadata());
                    this.put("scheduleType", CreateEventMasterTask.this.request.getScheduleType());
                    this.put("absoluteBegin", CreateEventMasterTask.this.request.getAbsoluteBegin());
                    this.put("absoluteEnd", CreateEventMasterTask.this.request.getAbsoluteEnd());
                    this.put("repeatType", CreateEventMasterTask.this.request.getRepeatType());
                    this.put("repeatBeginDayOfMonth", CreateEventMasterTask.this.request.getRepeatBeginDayOfMonth());
                    this.put("repeatEndDayOfMonth", CreateEventMasterTask.this.request.getRepeatEndDayOfMonth());
                    this.put("repeatBeginDayOfWeek", CreateEventMasterTask.this.request.getRepeatBeginDayOfWeek());
                    this.put("repeatEndDayOfWeek", CreateEventMasterTask.this.request.getRepeatEndDayOfWeek());
                    this.put("repeatBeginHour", CreateEventMasterTask.this.request.getRepeatBeginHour());
                    this.put("repeatEndHour", CreateEventMasterTask.this.request.getRepeatEndHour());
                    this.put("relativeTriggerName", CreateEventMasterTask.this.request.getRelativeTriggerName());
                    this.put("relativeDuration", CreateEventMasterTask.this.request.getRelativeDuration());
                    this.put("contextStack", CreateEventMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventMastersTask
    extends Gs2RestSessionTask<DescribeEventMastersResult> {
        private DescribeEventMastersRequest request;

        public DescribeEventMastersTask(DescribeEventMastersRequest request, AsyncAction<AsyncResult<DescribeEventMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventMastersResult parse(JsonNode data) {
            return DescribeEventMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/event";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ScheduleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "schedule").replace("{region}", Gs2ScheduleRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

