/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.realtime.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.realtime.Gs2RealtimeRestClient;
import io.gs2.realtime.domain.model.NamespaceDomain;
import io.gs2.realtime.model.Room;
import io.gs2.realtime.request.DeleteRoomRequest;
import io.gs2.realtime.request.GetRoomRequest;
import io.gs2.realtime.result.DeleteRoomResult;
import io.gs2.realtime.result.GetRoomResult;

public class RoomDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RealtimeRestClient client;
    private final String namespaceName;
    private final String roomName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public RoomDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String roomName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RealtimeRestClient(session);
        this.namespaceName = namespaceName;
        this.roomName = roomName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Room");
    }

    private Room get(GetRoomRequest request) {
        request.withNamespaceName(this.namespaceName).withRoomName(this.roomName);
        GetRoomResult result = this.client.getRoom(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RoomDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public RoomDomain delete(DeleteRoomRequest request) {
        request.withNamespaceName(this.namespaceName).withRoomName(this.roomName);
        DeleteRoomResult result = null;
        try {
            result = this.client.deleteRoom(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, RoomDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), Room.class);
        RoomDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String roomName, String childType) {
        return String.join((CharSequence)":", "realtime", namespaceName, roomName, childType);
    }

    public static String createCacheKey(String roomName) {
        return String.join((CharSequence)":", roomName);
    }

    public Room model() {
        Room value = this.cache.get(this.parentKey, RoomDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Room.class);
        if (value == null) {
            try {
                this.get(new GetRoomRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RoomDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Room.class);
            }
            value = this.cache.get(this.parentKey, RoomDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Room.class);
        }
        return value;
    }
}

