/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.iterator.DescribeRankingsIterator;
import io.gs2.ranking.domain.iterator.DescribeScoresIterator;
import io.gs2.ranking.domain.iterator.DescribeSubscribesByCategoryNameIterator;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.domain.model.RankingAccessTokenDomain;
import io.gs2.ranking.domain.model.ScoreAccessTokenDomain;
import io.gs2.ranking.domain.model.SubscribeAccessTokenDomain;
import io.gs2.ranking.domain.model.SubscribeUserAccessTokenDomain;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeSubscribesByCategoryNameIterator subscribesByCategoryName(String categoryName) {
        return new DescribeSubscribesByCategoryNameIterator(this.cache, this.client, this.namespaceName, categoryName, this.accessToken);
    }

    public SubscribeAccessTokenDomain subscribe(String categoryName) {
        return new SubscribeAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, categoryName);
    }

    public SubscribeUserAccessTokenDomain subscribeUser(String categoryName, String targetUserId) {
        return new SubscribeUserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, categoryName, targetUserId);
    }

    public DescribeRankingsIterator rankings(String categoryName) {
        return new DescribeRankingsIterator(this.cache, this.client, this.namespaceName, categoryName, this.accessToken);
    }

    public RankingAccessTokenDomain ranking(String categoryName) {
        return new RankingAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, categoryName);
    }

    public DescribeScoresIterator scores(String categoryName, String scorerUserId) {
        return new DescribeScoresIterator(this.cache, this.client, this.namespaceName, categoryName, this.accessToken, scorerUserId);
    }

    public ScoreAccessTokenDomain score(String categoryName, String scorerUserId, String uniqueId) {
        return new ScoreAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, categoryName, scorerUserId, uniqueId);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

