/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.SubscribeUserDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.SubscribeUser;
import io.gs2.ranking.request.GetSubscribeRequest;
import io.gs2.ranking.request.UnsubscribeRequest;
import io.gs2.ranking.result.GetSubscribeResult;
import io.gs2.ranking.result.UnsubscribeResult;

public class SubscribeUserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String categoryName;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public SubscribeUserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String categoryName, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.categoryName = categoryName;
        this.targetUserId = targetUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "SubscribeUser");
    }

    private SubscribeUser get(GetSubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName).withTargetUserId(this.targetUserId);
        GetSubscribeResult result = this.client.getSubscribe(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SubscribeUserAccessTokenDomain unsubscribe(UnsubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName).withTargetUserId(this.targetUserId);
        UnsubscribeResult result = null;
        try {
            result = this.client.unsubscribe(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), SubscribeUser.class);
        SubscribeUserAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String targetUserId, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, targetUserId, childType);
    }

    public static String createCacheKey(String categoryName, String targetUserId) {
        return String.join((CharSequence)":", categoryName, targetUserId);
    }

    public SubscribeUser model() {
        SubscribeUser value = this.cache.get(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
        if (value == null) {
            try {
                this.get(new GetSubscribeRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
            }
            value = this.cache.get(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
        }
        return value;
    }
}

