/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Score;
import io.gs2.ranking.request.GetScoreByUserIdRequest;
import io.gs2.ranking.result.GetScoreByUserIdResult;

public class ScoreDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String categoryName;
    private final String scorerUserId;
    private final String uniqueId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getScorerUserId() {
        return this.scorerUserId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public ScoreDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String categoryName, String scorerUserId, String uniqueId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.categoryName = categoryName;
        this.scorerUserId = scorerUserId;
        this.uniqueId = uniqueId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Score");
    }

    private Score get(GetScoreByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName).withScorerUserId(this.scorerUserId).withUniqueId(this.uniqueId);
        GetScoreByUserIdResult result = this.client.getScoreByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ScoreDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getScorerUserId() != null ? request.getScorerUserId().toString() : null, request.getUniqueId() != null ? request.getUniqueId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String scorerUserId, String uniqueId, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, scorerUserId, uniqueId, childType);
    }

    public static String createCacheKey(String categoryName, String scorerUserId, String uniqueId) {
        return String.join((CharSequence)":", categoryName, scorerUserId, uniqueId);
    }

    public Score model() {
        Score value = this.cache.get(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
        if (value == null) {
            try {
                this.get(new GetScoreByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
            }
            value = this.cache.get(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
        }
        return value;
    }
}

