/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.ScoreDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Score;
import io.gs2.ranking.request.GetScoreRequest;
import io.gs2.ranking.result.GetScoreResult;

public class ScoreAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String categoryName;
    private final String scorerUserId;
    private final String uniqueId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getScorerUserId() {
        return this.scorerUserId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public ScoreAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String categoryName, String scorerUserId, String uniqueId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.categoryName = categoryName;
        this.scorerUserId = scorerUserId;
        this.uniqueId = uniqueId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Score");
    }

    private Score get(GetScoreRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName).withScorerUserId(this.scorerUserId).withUniqueId(this.uniqueId);
        GetScoreResult result = this.client.getScore(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ScoreDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getScorerUserId() != null ? request.getScorerUserId().toString() : null, request.getUniqueId() != null ? request.getUniqueId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String scorerUserId, String uniqueId, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, scorerUserId, uniqueId, childType);
    }

    public static String createCacheKey(String categoryName, String scorerUserId, String uniqueId) {
        return String.join((CharSequence)":", categoryName, scorerUserId, uniqueId);
    }

    public Score model() {
        Score value = this.cache.get(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
        if (value == null) {
            try {
                this.get(new GetScoreRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
            }
            value = this.cache.get(this.parentKey, ScoreDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getScorerUserId() != null ? this.getScorerUserId().toString() : null, this.getUniqueId() != null ? this.getUniqueId().toString() : null), Score.class);
        }
        return value;
    }
}

