/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.model.CategoryModelMaster;
import io.gs2.ranking.request.DeleteCategoryModelMasterRequest;
import io.gs2.ranking.request.GetCategoryModelMasterRequest;
import io.gs2.ranking.request.UpdateCategoryModelMasterRequest;
import io.gs2.ranking.result.DeleteCategoryModelMasterResult;
import io.gs2.ranking.result.GetCategoryModelMasterResult;
import io.gs2.ranking.result.UpdateCategoryModelMasterResult;

public class CategoryModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public CategoryModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.categoryName = categoryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CategoryModelMaster");
    }

    private CategoryModelMaster get(GetCategoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withCategoryName(this.categoryName);
        GetCategoryModelMasterResult result = this.client.getCategoryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CategoryModelMasterDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CategoryModelMasterDomain update(UpdateCategoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withCategoryName(this.categoryName);
        UpdateCategoryModelMasterResult result = this.client.updateCategoryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CategoryModelMasterDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CategoryModelMasterDomain domain = this;
        return domain;
    }

    public CategoryModelMasterDomain delete(DeleteCategoryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withCategoryName(this.categoryName);
        DeleteCategoryModelMasterResult result = null;
        try {
            result = this.client.deleteCategoryModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, CategoryModelMasterDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), CategoryModelMaster.class);
        CategoryModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public CategoryModelMaster model() {
        CategoryModelMaster value = this.cache.get(this.parentKey, CategoryModelMasterDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetCategoryModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CategoryModelMasterDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModelMaster.class);
            }
            value = this.cache.get(this.parentKey, CategoryModelMasterDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModelMaster.class);
        }
        return value;
    }
}

